/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ai.functions;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.opentelemetry.api.trace.Tracer;
import io.trino.plugin.ai.functions.AiModule;
import io.trino.plugin.base.Versions;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;

public class AiConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "ai";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        Bootstrap app = new Bootstrap(new Module[]{new AiModule(), binder -> {
            binder.bind(Tracer.class).toInstance((Object)context.getTracer());
            binder.bind(CatalogName.class).toInstance((Object)new CatalogName(catalogName));
        }});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (Connector)injector.getInstance(Connector.class);
    }
}

