/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.io.ByteBufferAccumulator;
import org.eclipse.jetty.io.ByteBufferInputStream;
import org.eclipse.jetty.io.ByteBufferPool;

public abstract class BufferingResponseListener
implements Response.Listener {
    private final ByteBufferAccumulator buffer;
    private final int maxLength;

    public BufferingResponseListener(ByteBufferPool byteBufferPool) {
        this(byteBufferPool, 0x200000);
    }

    public BufferingResponseListener(ByteBufferPool byteBufferPool, int maxLength) {
        this.buffer = new ByteBufferAccumulator(Objects.requireNonNull(byteBufferPool, "byteBufferPool is null"), false);
        if (maxLength < 0) {
            throw new IllegalArgumentException("Invalid max length " + maxLength);
        }
        this.maxLength = maxLength;
    }

    public void onHeaders(Response response) {
        Request request = response.getRequest();
        HttpFields headers = response.getHeaders();
        long length = headers.getLongField(HttpHeader.CONTENT_LENGTH);
        if (HttpMethod.HEAD.is(request.getMethod())) {
            length = 0L;
        }
        if (length > (long)this.maxLength) {
            response.abort((Throwable)new IllegalArgumentException("Buffering capacity " + this.maxLength + " exceeded"));
        }
    }

    public void onContent(Response response, ByteBuffer content) {
        int length = content.remaining();
        if (length == 0) {
            return;
        }
        this.buffer.copyBuffer(content);
    }

    public abstract void onComplete(Result var1);

    public InputStream getContentAsInputStream() {
        return new ByteBufferInputStream(this.buffer.takeByteBuffer());
    }
}

