/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ai.functions;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class AiMetadata
implements ConnectorMetadata {
    private static final String SCHEMA_NAME = "ai";
    private final List<FunctionMetadata> functions;

    @Inject
    public AiMetadata(List<FunctionMetadata> functions) {
        this.functions = ImmutableList.copyOf((Collection)Objects.requireNonNull(functions, "functions is null"));
    }

    public Collection<FunctionMetadata> listFunctions(ConnectorSession session, String schemaName) {
        return schemaName.equals(SCHEMA_NAME) ? this.functions : List.of();
    }

    public Collection<FunctionMetadata> getFunctions(ConnectorSession session, SchemaFunctionName name) {
        if (!name.getSchemaName().equals(SCHEMA_NAME)) {
            return List.of();
        }
        return this.functions.stream().filter(function -> function.getCanonicalName().equals(name.getFunctionName())).toList();
    }

    public FunctionMetadata getFunctionMetadata(ConnectorSession session, FunctionId functionId) {
        return this.functions.stream().filter(function -> function.getFunctionId().equals((Object)functionId)).findFirst().orElseThrow();
    }

    public FunctionDependencyDeclaration getFunctionDependencies(ConnectorSession session, FunctionId functionId, BoundSignature boundSignature) {
        return FunctionDependencyDeclaration.builder().addType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())).build();
    }
}

