/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ai.functions;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.trino.plugin.ai.functions.AiConfig;
import io.trino.plugin.ai.functions.AiConnector;
import io.trino.plugin.ai.functions.AiFunctions;
import io.trino.plugin.ai.functions.AiMetadata;
import io.trino.plugin.ai.functions.AiProvider;
import io.trino.plugin.ai.functions.AnthropicModule;
import io.trino.plugin.ai.functions.OpenAiModule;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.FunctionProvider;
import java.util.List;

public class AiModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(AiConnector.class).in(Scopes.SINGLETON);
        binder.bind(AiMetadata.class).in(Scopes.SINGLETON);
        binder.bind(AiFunctions.class).in(Scopes.SINGLETON);
        binder.bind(Connector.class).to(AiConnector.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorMetadata.class).to(AiMetadata.class).in(Scopes.SINGLETON);
        binder.bind(FunctionProvider.class).to(AiFunctions.class).in(Scopes.SINGLETON);
        this.install((Module)(switch (((AiConfig)this.buildConfigObject(AiConfig.class)).getProvider()) {
            default -> throw new MatchException(null, null);
            case AiProvider.ANTHROPIC -> new AnthropicModule();
            case AiProvider.OPENAI -> new OpenAiModule();
        }));
    }

    @Provides
    public static List<FunctionMetadata> getFunctionMetadata(AiFunctions functions) {
        return functions.getFunctions();
    }
}

