/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.atop;

import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.atop.AtopMetadata;
import io.trino.plugin.atop.AtopPageSourceProvider;
import io.trino.plugin.atop.AtopSplitManager;
import io.trino.plugin.atop.AtopTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Objects;
import javax.inject.Inject;

public class AtopConnector
implements Connector {
    private final LifeCycleManager lifeCycleManager;
    private final AtopMetadata metadata;
    private final AtopSplitManager splitManager;
    private final AtopPageSourceProvider pageSourceProvider;
    private final ConnectorAccessControl accessControl;

    @Inject
    public AtopConnector(LifeCycleManager lifeCycleManager, AtopMetadata metadata, AtopSplitManager splitManager, AtopPageSourceProvider pageSourceProvider, ConnectorAccessControl accessControl) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        return AtopTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl;
    }

    public final void shutdown() {
        this.lifeCycleManager.stop();
    }
}

