/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.atop;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

public class AtopSplit
implements ConnectorSplit {
    private final HostAddress host;
    private final ZonedDateTime date;

    @JsonCreator
    public AtopSplit(@JsonProperty(value="host") HostAddress host, @JsonProperty(value="epochSeconds") long epochSeconds, @JsonProperty(value="timeZone") ZoneId timeZone) {
        this.host = Objects.requireNonNull(host, "host is null");
        Objects.requireNonNull(timeZone, "timeZone is null");
        this.date = ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSeconds), timeZone);
    }

    @JsonProperty
    public HostAddress getHost() {
        return this.host;
    }

    @JsonProperty
    public long getEpochSeconds() {
        return this.date.toEpochSecond();
    }

    @JsonProperty
    public ZoneId getTimeZone() {
        return this.date.getZone();
    }

    public ZonedDateTime getDate() {
        return this.date;
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of((Object)HostAddress.fromString((String)this.host.getHostText()));
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("host", (Object)this.host).add("date", (Object)this.date).toString();
    }
}

