/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.atop;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigurationAwareModule;
import io.airlift.json.JsonModule;
import io.trino.plugin.atop.AtopConnector;
import io.trino.plugin.atop.AtopConnectorConfig;
import io.trino.plugin.atop.AtopFactory;
import io.trino.plugin.atop.AtopModule;
import io.trino.plugin.base.CatalogNameModule;
import io.trino.plugin.base.Versions;
import io.trino.plugin.base.security.ConnectorAccessControlModule;
import io.trino.plugin.base.security.FileBasedAccessControlModule;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;
import java.util.Objects;

public class AtopConnectorFactory
implements ConnectorFactory {
    private final Class<? extends AtopFactory> atopFactoryClass;
    private final ClassLoader classLoader;

    public AtopConnectorFactory(Class<? extends AtopFactory> atopFactoryClass, ClassLoader classLoader) {
        this.atopFactoryClass = Objects.requireNonNull(atopFactoryClass, "atopFactoryClass is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public String getName() {
        return "atop";
    }

    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        Versions.checkStrictSpiVersionMatch((ConnectorContext)context, (ConnectorFactory)this);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new AtopModule(this.atopFactoryClass, context.getTypeManager(), context.getNodeManager(), context.getNodeManager().getEnvironment()), new CatalogNameModule(catalogName), new ConnectorAccessControlModule(), ConditionalModule.conditionalModule(AtopConnectorConfig.class, config -> config.getSecurity() == AtopConnectorConfig.AtopSecurity.FILE, (Module)ConfigurationAwareModule.combine((Module[])new Module[]{new FileBasedAccessControlModule(), new JsonModule()}))});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
            Connector connector = (Connector)injector.getInstance(AtopConnector.class);
            return connector;
        }
    }
}

