/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.atop;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.inject.Inject;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import io.trino.plugin.atop.Atop;
import io.trino.plugin.atop.AtopConnectorConfig;
import io.trino.plugin.atop.AtopErrorCode;
import io.trino.plugin.atop.AtopFactory;
import io.trino.plugin.atop.AtopTable;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import jakarta.annotation.PreDestroy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class AtopProcessFactory
implements AtopFactory {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    private final String executablePath;
    private final ZoneId timeZone;
    private final Duration readTimeout;
    private final ExecutorService executor;

    @Inject
    public AtopProcessFactory(AtopConnectorConfig config, CatalogName catalogName) {
        this.executablePath = config.getExecutablePath();
        this.timeZone = config.getTimeZoneId();
        this.readTimeout = config.getReadTimeout();
        this.executor = Executors.newFixedThreadPool(config.getConcurrentReadersPerNode(), Threads.daemonThreadsNamed((String)("atop-" + String.valueOf(catalogName) + "executable-reader-%s")));
    }

    @Override
    public Atop create(AtopTable table, ZonedDateTime date) {
        Process process;
        Preconditions.checkArgument((boolean)date.getZone().getRules().equals(this.timeZone.getRules()), (String)"Split date (%s) is not in the local timezone (%s)", (Object)date.getZone(), (Object)this.timeZone);
        ProcessBuilder processBuilder = new ProcessBuilder(this.executablePath);
        processBuilder.command().add("-P");
        processBuilder.command().add(table.getAtopLabel());
        processBuilder.command().add("-r");
        processBuilder.command().add(DATE_FORMATTER.format(date));
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)AtopErrorCode.ATOP_CANNOT_START_PROCESS_ERROR, String.format("Cannot start %s", processBuilder.command()), (Throwable)e);
        }
        return new AtopProcess(process, this.readTimeout, this.executor);
    }

    @PreDestroy
    public void shutdown() {
        this.executor.shutdownNow();
    }

    private static final class AtopProcess
    implements Atop {
        private final Process process;
        private final BufferedReader underlyingReader;
        private final LineReader reader;
        private String line;

        private AtopProcess(Process process, Duration readTimeout, ExecutorService executor) {
            this.process = Objects.requireNonNull(process, "process is null");
            this.underlyingReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));
            SimpleTimeLimiter limiter = SimpleTimeLimiter.create((ExecutorService)executor);
            this.reader = (LineReader)limiter.newProxy(this.underlyingReader::readLine, LineReader.class, readTimeout.toMillis(), TimeUnit.MILLISECONDS);
            try {
                this.reader.readLine();
                this.reader.readLine();
                this.line = this.reader.readLine();
            }
            catch (IOException e) {
                this.line = null;
            }
            catch (UncheckedTimeoutException e) {
                throw new TrinoException((ErrorCodeSupplier)AtopErrorCode.ATOP_READ_TIMEOUT, "Timeout reading from atop process");
            }
        }

        @Override
        public boolean hasNext() {
            return this.line != null;
        }

        @Override
        public String next() {
            if (this.line == null) {
                throw new NoSuchElementException();
            }
            String currentLine = this.line;
            try {
                this.line = this.reader.readLine();
            }
            catch (IOException e) {
                this.line = null;
            }
            catch (UncheckedTimeoutException e) {
                throw new TrinoException((ErrorCodeSupplier)AtopErrorCode.ATOP_READ_TIMEOUT, "Timeout reading from atop process");
            }
            return currentLine;
        }

        @Override
        public void close() {
            try {
                this.underlyingReader.close();
            }
            catch (IOException e) {
            }
            finally {
                this.process.destroy();
                try {
                    if (!this.process.waitFor(5L, TimeUnit.SECONDS)) {
                        this.process.destroyForcibly();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.process.destroyForcibly();
                }
            }
        }
    }

    public static interface LineReader {
        public String readLine() throws IOException;
    }
}

