/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.atop;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.plugin.atop.AtopTable;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.Objects;

public class AtopTableHandle
implements ConnectorTableHandle {
    private final String schema;
    private final AtopTable table;
    private final Domain startTimeConstraint;
    private final Domain endTimeConstraint;

    public AtopTableHandle(String schema, AtopTable table) {
        this(schema, table, Domain.all((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS), Domain.all((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS));
    }

    @JsonCreator
    public AtopTableHandle(@JsonProperty(value="schema") String schema, @JsonProperty(value="table") AtopTable table, @JsonProperty(value="startTimeConstraint") Domain startTimeConstraint, @JsonProperty(value="endTimeConstraint") Domain endTimeConstraint) {
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.startTimeConstraint = Objects.requireNonNull(startTimeConstraint, "startTimeConstraint is null");
        this.endTimeConstraint = Objects.requireNonNull(endTimeConstraint, "endTimeConstraint is null");
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public AtopTable getTable() {
        return this.table;
    }

    @JsonProperty
    public Domain getStartTimeConstraint() {
        return this.startTimeConstraint;
    }

    @JsonProperty
    public Domain getEndTimeConstraint() {
        return this.endTimeConstraint;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.schema, this.table, this.startTimeConstraint, this.endTimeConstraint});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AtopTableHandle other = (AtopTableHandle)obj;
        return Objects.equals(this.schema, other.schema) && this.table == other.table && Objects.equals(this.startTimeConstraint, other.startTimeConstraint) && Objects.equals(this.endTimeConstraint, other.endTimeConstraint);
    }

    public String toString() {
        return this.schema + ":" + String.valueOf((Object)this.table);
    }
}

