/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.reflect.Reflection;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.airlift.log.Logger;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.base.util.LoggingInvocationHandler;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.ForwardingJdbcClient;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.StatsCollecting;
import io.trino.plugin.jdbc.jmx.StatisticsAwareConnectionFactory;
import io.trino.plugin.jdbc.jmx.StatisticsAwareJdbcClient;
import java.lang.reflect.InvocationHandler;
import org.weakref.jmx.guice.ExportBinder;
import org.weakref.jmx.guice.MBeanModule;

public class JdbcDiagnosticModule
implements Module {
    public void configure(Binder binder) {
        binder.install((Module)new MBeanServerModule());
        binder.install((Module)new MBeanModule());
        Provider catalogName = binder.getProvider(CatalogName.class);
        ExportBinder.newExporter((Binder)binder).export(Key.get(JdbcClient.class, StatsCollecting.class)).as(generator -> generator.generatedNameOf(JdbcClient.class, ((CatalogName)catalogName.get()).toString()));
        ExportBinder.newExporter((Binder)binder).export(Key.get(ConnectionFactory.class, StatsCollecting.class)).as(generator -> generator.generatedNameOf(ConnectionFactory.class, ((CatalogName)catalogName.get()).toString()));
    }

    @Provides
    @Singleton
    @StatsCollecting
    public JdbcClient createJdbcClientWithStats(@ForBaseJdbc JdbcClient client, CatalogName catalogName) {
        Logger logger = Logger.get((String)String.format("io.trino.plugin.jdbc.%s.jdbcclient", catalogName));
        JdbcClient loggingInvocationsJdbcClient = (JdbcClient)Reflection.newProxy(JdbcClient.class, (InvocationHandler)new LoggingInvocationHandler((Object)client, (LoggingInvocationHandler.ParameterNamesProvider)new LoggingInvocationHandler.ReflectiveParameterNamesProvider(), arg_0 -> ((Logger)logger).debug(arg_0)));
        return new StatisticsAwareJdbcClient(ForwardingJdbcClient.of(() -> {
            if (logger.isDebugEnabled()) {
                return loggingInvocationsJdbcClient;
            }
            return client;
        }));
    }

    @Provides
    @Singleton
    @StatsCollecting
    public static ConnectionFactory createConnectionFactoryWithStats(@ForBaseJdbc ConnectionFactory connectionFactory) {
        return new StatisticsAwareConnectionFactory(connectionFactory);
    }
}

