/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcMetadataSessionProperties;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcQueryRelationHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNewTableLayout;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class JdbcMetadata
implements ConnectorMetadata {
    private static final String SYNTHETIC_COLUMN_NAME_PREFIX = "_pfgnrtd_";
    private final JdbcClient jdbcClient;
    private final boolean allowDropTable;
    private final AtomicReference<Runnable> rollbackAction = new AtomicReference();

    public JdbcMetadata(JdbcClient jdbcClient, boolean allowDropTable) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "client is null");
        this.allowDropTable = allowDropTable;
    }

    public boolean schemaExists(ConnectorSession session, String schemaName) {
        return this.jdbcClient.schemaExists(session, schemaName);
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.copyOf(this.jdbcClient.getSchemaNames(session));
    }

    public JdbcTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return this.jdbcClient.getTableHandle(session, tableName).orElse(null);
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return this.jdbcClient.getSystemTable(session, tableName);
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        TupleDomain remainingFilter;
        JdbcTableHandle handle = (JdbcTableHandle)table;
        TupleDomain<ColumnHandle> oldDomain = handle.getConstraint();
        TupleDomain newDomain = oldDomain.intersect(constraint.getSummary());
        if (newDomain.isNone()) {
            remainingFilter = TupleDomain.all();
        } else {
            Map domains = (Map)newDomain.getDomains().orElseThrow();
            List columnHandles = (List)domains.keySet().stream().map(JdbcColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
            List<ColumnMapping> columnMappings = this.jdbcClient.toColumnMappings(session, (List)columnHandles.stream().map(JdbcColumnHandle::getJdbcTypeHandle).collect(ImmutableList.toImmutableList()));
            HashMap<JdbcColumnHandle, Domain> supported = new HashMap<JdbcColumnHandle, Domain>();
            HashMap<JdbcColumnHandle, Domain> unsupported = new HashMap<JdbcColumnHandle, Domain>();
            for (int i = 0; i < columnHandles.size(); ++i) {
                JdbcColumnHandle column = (JdbcColumnHandle)columnHandles.get(i);
                ColumnMapping mapping = columnMappings.get(i);
                PredicatePushdownController.DomainPushdownResult pushdownResult = mapping.getPredicatePushdownController().apply(session, (Domain)domains.get(column));
                supported.put(column, pushdownResult.getPushedDown());
                unsupported.put(column, pushdownResult.getRemainingFilter());
            }
            newDomain = TupleDomain.withColumnDomains(supported);
            remainingFilter = TupleDomain.withColumnDomains(unsupported);
        }
        if (oldDomain.equals((Object)newDomain)) {
            return Optional.empty();
        }
        handle = new JdbcTableHandle(handle.getRelationHandle(), (TupleDomain<ColumnHandle>)newDomain, handle.getLimit(), handle.getColumns(), handle.getNextSyntheticColumnId());
        return Optional.of(new ConstraintApplicationResult((Object)handle, remainingFilter));
    }

    private JdbcTableHandle flushAttributesAsQuery(ConnectorSession session, JdbcTableHandle handle) {
        List<JdbcColumnHandle> columns = this.jdbcClient.getColumns(session, handle);
        PreparedQuery preparedQuery = this.jdbcClient.prepareQuery(session, handle, Optional.empty(), columns, (Map<String, String>)ImmutableMap.of());
        return new JdbcTableHandle(new JdbcQueryRelationHandle(preparedQuery), (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalLong.empty(), Optional.of(columns), handle.getNextSyntheticColumnId());
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle table, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        List newColumns = (List)assignments.values().stream().map(JdbcColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        if (handle.getColumns().isPresent() && JdbcMetadata.containSameElements(newColumns, (Iterable<? extends ColumnHandle>)handle.getColumns().get())) {
            return Optional.empty();
        }
        return Optional.of(new ProjectionApplicationResult((Object)new JdbcTableHandle(handle.getRelationHandle(), handle.getConstraint(), handle.getLimit(), Optional.of(newColumns), handle.getNextSyntheticColumnId()), projections, (List)assignments.entrySet().stream().map(assignment -> new Assignment((String)assignment.getKey(), (ColumnHandle)assignment.getValue(), ((JdbcColumnHandle)assignment.getValue()).getColumnType())).collect(ImmutableList.toImmutableList())));
    }

    public Optional<AggregationApplicationResult<ConnectorTableHandle>> applyAggregation(ConnectorSession session, ConnectorTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        if (!JdbcMetadataSessionProperties.isAggregationPushdownEnabled(session)) {
            return Optional.empty();
        }
        JdbcTableHandle handle = (JdbcTableHandle)table;
        Verify.verify((!groupingSets.isEmpty() ? 1 : 0) != 0, (String)"No grouping sets provided", (Object[])new Object[0]);
        if (!this.jdbcClient.supportsAggregationPushdown(session, handle, groupingSets)) {
            return Optional.empty();
        }
        if (handle.getLimit().isPresent()) {
            handle = this.flushAttributesAsQuery(session, handle);
        }
        int nextSyntheticColumnId = handle.getNextSyntheticColumnId();
        ImmutableList.Builder newColumns = ImmutableList.builder();
        ImmutableList.Builder projections = ImmutableList.builder();
        ImmutableList.Builder resultAssignments = ImmutableList.builder();
        ImmutableMap.Builder expressions = ImmutableMap.builder();
        for (AggregateFunction aggregate : aggregates) {
            Optional<JdbcExpression> expression = this.jdbcClient.implementAggregation(session, aggregate, assignments);
            if (expression.isEmpty()) {
                return Optional.empty();
            }
            String columnName = SYNTHETIC_COLUMN_NAME_PREFIX + nextSyntheticColumnId;
            ++nextSyntheticColumnId;
            JdbcColumnHandle newColumn = JdbcColumnHandle.builder().setColumnName(columnName).setJdbcTypeHandle(expression.get().getJdbcTypeHandle()).setColumnType(aggregate.getOutputType()).setComment(Optional.of("synthetic")).build();
            newColumns.add((Object)newColumn);
            projections.add((Object)new Variable(newColumn.getColumnName(), aggregate.getOutputType()));
            resultAssignments.add((Object)new Assignment(newColumn.getColumnName(), (ColumnHandle)newColumn, aggregate.getOutputType()));
            expressions.put((Object)columnName, (Object)expression.get().getExpression());
        }
        List groupingSetsAsJdbcColumnHandles = (List)groupingSets.stream().map(groupingSet -> (ImmutableList)groupingSet.stream().map(JdbcColumnHandle.class::cast).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        ImmutableList newColumnsList = newColumns.build();
        PreparedQuery preparedQuery = this.jdbcClient.prepareQuery(session, handle, Optional.of(groupingSetsAsJdbcColumnHandles), (List<JdbcColumnHandle>)ImmutableList.builder().addAll(groupingSetsAsJdbcColumnHandles.stream().flatMap(Collection::stream).distinct().iterator()).addAll((Iterable)newColumnsList).build(), (Map<String, String>)expressions.build());
        handle = new JdbcTableHandle(new JdbcQueryRelationHandle(preparedQuery), (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalLong.empty(), Optional.of(newColumnsList), nextSyntheticColumnId);
        return Optional.of(new AggregationApplicationResult((Object)handle, (List)projections.build(), (List)resultAssignments.build(), (Map)ImmutableMap.of()));
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        if (!this.jdbcClient.supportsLimit()) {
            return Optional.empty();
        }
        if (handle.getLimit().isPresent() && handle.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        handle = new JdbcTableHandle(handle.getRelationHandle(), handle.getConstraint(), OptionalLong.of(limit), handle.getColumns(), handle.getNextSyntheticColumnId());
        return Optional.of(new LimitApplicationResult((Object)handle, this.jdbcClient.isLimitGuaranteed(session)));
    }

    public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        return this.jdbcClient.getTableScanRedirection(session, tableHandle);
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        ImmutableList.Builder columnMetadata = ImmutableList.builder();
        for (JdbcColumnHandle column : this.jdbcClient.getColumns(session, handle)) {
            columnMetadata.add((Object)column.getColumnMetadata());
        }
        SchemaTableName schemaTableName = handle.isNamedRelation() ? handle.getRequiredNamedRelation().getSchemaTableName() : new SchemaTableName("_prepared", "query");
        return new ConnectorTableMetadata(schemaTableName, (List)columnMetadata.build(), this.jdbcClient.getTableProperties(session, handle));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return this.jdbcClient.getTableNames(session, schemaName);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return (Map)this.jdbcClient.getColumns(session, (JdbcTableHandle)tableHandle).stream().collect(ImmutableMap.toImmutableMap(columnHandle -> columnHandle.getColumnMetadata().getName(), (Function)Functions.identity()));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder columns = ImmutableMap.builder();
        List tables = prefix.toOptionalSchemaTableName().map(ImmutableList::of).orElseGet(() -> this.listTables(session, prefix.getSchema()));
        for (SchemaTableName tableName : tables) {
            try {
                this.jdbcClient.getTableHandle(session, tableName).ifPresent(tableHandle -> columns.put((Object)tableName, (Object)this.getTableMetadata(session, (ConnectorTableHandle)tableHandle).getColumns()));
            }
            catch (TableNotFoundException tableNotFoundException) {}
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((JdbcColumnHandle)columnHandle).getColumnMetadata();
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        if (!this.allowDropTable) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.PERMISSION_DENIED, "DROP TABLE is disabled in this catalog");
        }
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        Verify.verify((!handle.isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)handle);
        this.jdbcClient.dropTable(session, handle);
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        JdbcOutputTableHandle handle = this.jdbcClient.beginCreateTable(session, tableMetadata);
        this.setRollback(() -> this.jdbcClient.rollbackCreateTable(session, handle));
        return handle;
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        this.jdbcClient.createTable(session, tableMetadata);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        JdbcOutputTableHandle handle = (JdbcOutputTableHandle)tableHandle;
        this.jdbcClient.commitCreateTable(session, handle);
        return Optional.empty();
    }

    private void setRollback(Runnable action) {
        Preconditions.checkState((boolean)this.rollbackAction.compareAndSet(null, action), (Object)"rollback action is already set");
    }

    public void rollback() {
        Optional.ofNullable(this.rollbackAction.getAndSet(null)).ifPresent(Runnable::run);
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns) {
        Verify.verify((!((JdbcTableHandle)tableHandle).isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)tableHandle);
        List columnHandles = (List)columns.stream().map(JdbcColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        JdbcOutputTableHandle handle = this.jdbcClient.beginInsertTable(session, (JdbcTableHandle)tableHandle, columnHandles);
        this.setRollback(() -> this.jdbcClient.rollbackCreateTable(session, handle));
        return handle;
    }

    public boolean supportsMissingColumnsOnInsert() {
        return true;
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        JdbcOutputTableHandle jdbcInsertHandle = (JdbcOutputTableHandle)tableHandle;
        this.jdbcClient.finishInsertTable(session, jdbcInsertHandle);
        return Optional.empty();
    }

    public void setColumnComment(ConnectorSession session, ConnectorTableHandle table, ColumnHandle column, Optional<String> comment) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)column;
        Verify.verify((!tableHandle.isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)tableHandle);
        this.jdbcClient.setColumnComment(session, tableHandle, columnHandle, comment);
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle table, ColumnMetadata columnMetadata) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        Verify.verify((!tableHandle.isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)tableHandle);
        this.jdbcClient.addColumn(session, tableHandle, columnMetadata);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle table, ColumnHandle column) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)column;
        Verify.verify((!tableHandle.isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)tableHandle);
        this.jdbcClient.dropColumn(session, tableHandle, columnHandle);
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle table, ColumnHandle column, String target) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        JdbcColumnHandle columnHandle = (JdbcColumnHandle)column;
        Verify.verify((!tableHandle.isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)tableHandle);
        this.jdbcClient.renameColumn(session, tableHandle, columnHandle, target);
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle table, SchemaTableName newTableName) {
        JdbcTableHandle tableHandle = (JdbcTableHandle)table;
        Verify.verify((!tableHandle.isSynthetic() ? 1 : 0) != 0, (String)"Not a table reference: %s", (Object)tableHandle);
        this.jdbcClient.renameTable(session, tableHandle, newTableName);
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        return this.jdbcClient.getTableStatistics(session, handle, (TupleDomain<ColumnHandle>)constraint.getSummary());
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        this.jdbcClient.createSchema(session, schemaName);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        this.jdbcClient.dropSchema(session, schemaName);
    }

    private static boolean containSameElements(Iterable<? extends ColumnHandle> first, Iterable<? extends ColumnHandle> second) {
        return ImmutableSet.copyOf(first).equals((Object)ImmutableSet.copyOf(second));
    }
}

