/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.LegacyConfig;
import javax.validation.constraints.Min;

public class JdbcMetadataConfig {
    private boolean allowDropTable;
    private boolean aggregationPushdownEnabled = true;
    private int domainCompactionThreshold = 32;

    public boolean isAllowDropTable() {
        return this.allowDropTable;
    }

    @Config(value="allow-drop-table")
    @ConfigDescription(value="Allow connector to drop tables")
    public JdbcMetadataConfig setAllowDropTable(boolean allowDropTable) {
        this.allowDropTable = allowDropTable;
        return this;
    }

    public boolean isAggregationPushdownEnabled() {
        return this.aggregationPushdownEnabled;
    }

    @Config(value="aggregation-pushdown.enabled")
    @LegacyConfig(value={"allow-aggregation-pushdown"})
    @ConfigDescription(value="Enable aggregation pushdown")
    public JdbcMetadataConfig setAggregationPushdownEnabled(boolean aggregationPushdownEnabled) {
        this.aggregationPushdownEnabled = aggregationPushdownEnabled;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getDomainCompactionThreshold() {
        return this.domainCompactionThreshold;
    }

    @Config(value="domain-compaction-threshold")
    @ConfigDescription(value="Maximum ranges to allow in a tuple domain without compacting it")
    public JdbcMetadataConfig setDomainCompactionThreshold(int domainCompactionThreshold) {
        this.domainCompactionThreshold = domainCompactionThreshold;
        return this;
    }
}

