/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.units.Duration;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcMetadata;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.TransactionCachingJdbcClient;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class JdbcMetadataFactory {
    private final JdbcClient jdbcClient;
    private final boolean allowDropTable;

    @Inject
    public JdbcMetadataFactory(JdbcClient jdbcClient, JdbcMetadataConfig config) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        Objects.requireNonNull(config, "config is null");
        this.allowDropTable = config.isAllowDropTable();
    }

    public JdbcMetadata create() {
        return new JdbcMetadata(new TransactionCachingJdbcClient(this.jdbcClient, new Duration(1.0, TimeUnit.DAYS)), this.allowDropTable);
    }
}

