/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class JdbcPageSink
implements ConnectorPageSink {
    private final Connection connection;
    private final PreparedStatement statement;
    private final List<Type> columnTypes;
    private final List<WriteFunction> columnWriters;
    private int batchSize;

    public JdbcPageSink(ConnectorSession session, JdbcOutputTableHandle handle, JdbcClient jdbcClient) {
        try {
            this.connection = jdbcClient.getConnection(session, handle);
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        try {
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            JdbcPageSink.closeWithSuppression(this.connection, e);
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        this.columnTypes = handle.getColumnTypes();
        this.columnWriters = handle.getJdbcColumnTypes().isEmpty() ? (List)this.columnTypes.stream().map(type -> {
            WriteMapping writeMapping = jdbcClient.toWriteMapping(session, (Type)type);
            WriteFunction writeFunction = writeMapping.getWriteFunction();
            Verify.verify((type.getJavaType() == writeFunction.getJavaType() ? 1 : 0) != 0, (String)"Trino type %s is not compatible with write function %s accepting %s", (Object)type, (Object)writeFunction, writeFunction.getJavaType());
            return writeMapping;
        }).map(WriteMapping::getWriteFunction).collect(ImmutableList.toImmutableList()) : (List)handle.getJdbcColumnTypes().get().stream().map(typeHandle -> jdbcClient.toColumnMapping(session, this.connection, (JdbcTypeHandle)typeHandle).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Underlying type is not supported for INSERT: " + typeHandle))).map(ColumnMapping::getWriteFunction).collect(ImmutableList.toImmutableList());
        try {
            this.statement = this.connection.prepareStatement(jdbcClient.buildInsertSql(handle, this.columnWriters));
        }
        catch (SQLException e) {
            JdbcPageSink.closeWithSuppression(this.connection, e);
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public CompletableFuture<?> appendPage(Page page) {
        try {
            for (int position = 0; position < page.getPositionCount(); ++position) {
                for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                    this.appendColumn(page, position, channel);
                }
                this.statement.addBatch();
                ++this.batchSize;
                if (this.batchSize < 1000) continue;
                this.statement.executeBatch();
                this.connection.commit();
                this.connection.setAutoCommit(false);
                this.batchSize = 0;
            }
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
        return NOT_BLOCKED;
    }

    private void appendColumn(Page page, int position, int channel) throws SQLException {
        Block block = page.getBlock(channel);
        int parameterIndex = channel + 1;
        WriteFunction writeFunction = this.columnWriters.get(channel);
        if (block.isNull(position)) {
            writeFunction.setNull(this.statement, parameterIndex);
            return;
        }
        Type type = this.columnTypes.get(channel);
        Class javaType = type.getJavaType();
        if (javaType == Boolean.TYPE) {
            ((BooleanWriteFunction)writeFunction).set(this.statement, parameterIndex, type.getBoolean(block, position));
        } else if (javaType == Long.TYPE) {
            ((LongWriteFunction)writeFunction).set(this.statement, parameterIndex, type.getLong(block, position));
        } else if (javaType == Double.TYPE) {
            ((DoubleWriteFunction)writeFunction).set(this.statement, parameterIndex, type.getDouble(block, position));
        } else if (javaType == Slice.class) {
            ((SliceWriteFunction)writeFunction).set(this.statement, parameterIndex, type.getSlice(block, position));
        } else {
            ((ObjectWriteFunction)writeFunction).set(this.statement, parameterIndex, type.getObject(block, position));
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        try (Connection connection = this.connection;
             PreparedStatement statement = this.statement;){
            if (this.batchSize > 0) {
                statement.executeBatch();
                connection.commit();
            }
        }
        catch (SQLNonTransientException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_NON_TRANSIENT_ERROR, (Throwable)e);
        }
        catch (SQLException e) {
            for (SQLException nextException = e.getNextException(); nextException != null; nextException = nextException.getNextException()) {
                if (e == nextException) continue;
                e.addSuppressed(new Exception("Next SQLException", nextException));
            }
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed to insert data: " + MoreObjects.firstNonNull((Object)e.getMessage(), (Object)e), (Throwable)e);
        }
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
        try (Connection connection = this.connection;
             PreparedStatement statement = this.statement;){
            if (!connection.isClosed()) {
                connection.rollback();
            }
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private static void closeWithSuppression(Connection connection, Throwable throwable) {
        block2: {
            try {
                connection.close();
            }
            catch (Throwable t) {
                if (throwable == t) break block2;
                throwable.addSuppressed(t);
            }
        }
    }
}

