/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.trino.plugin.jdbc.JdbcMetadataSessionProperties;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.DiscreteValues;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Ranges;
import io.trino.spi.type.Type;
import java.util.Objects;

public interface PredicatePushdownController {
    public static final PredicatePushdownController FULL_PUSHDOWN = (session, domain) -> {
        if (PredicatePushdownController.getDomainSize(domain) > JdbcMetadataSessionProperties.getDomainCompactionThreshold(session)) {
            return new DomainPushdownResult(domain.simplify(JdbcMetadataSessionProperties.getDomainCompactionThreshold(session)), domain);
        }
        return new DomainPushdownResult(domain, Domain.all((Type)domain.getType()));
    };
    public static final PredicatePushdownController PUSHDOWN_AND_KEEP = (session, domain) -> new DomainPushdownResult(domain.simplify(JdbcMetadataSessionProperties.getDomainCompactionThreshold(session)), domain);
    public static final PredicatePushdownController DISABLE_PUSHDOWN = (session, domain) -> new DomainPushdownResult(Domain.all((Type)domain.getType()), domain);

    public DomainPushdownResult apply(ConnectorSession var1, Domain var2);

    private static int getDomainSize(Domain domain) {
        return (Integer)domain.getValues().getValuesProcessor().transform(Ranges::getRangeCount, DiscreteValues::getValuesCount, ignored -> 0);
    }

    public static final class DomainPushdownResult {
        private final Domain pushedDown;
        private final Domain remainingFilter;

        public DomainPushdownResult(Domain pushedDown, Domain remainingFilter) {
            this.pushedDown = Objects.requireNonNull(pushedDown, "pushedDown is null");
            this.remainingFilter = Objects.requireNonNull(remainingFilter, "remainingFilter is null");
        }

        public Domain getPushedDown() {
            return this.pushedDown;
        }

        public Domain getRemainingFilter() {
            return this.remainingFilter;
        }
    }
}

