/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.jdbc.QueryParameter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class PreparedQuery {
    private final String query;
    private final List<QueryParameter> parameters;

    @JsonCreator
    public PreparedQuery(String query, List<QueryParameter> parameters) {
        this.query = Objects.requireNonNull(query, "query is null");
        this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public List<QueryParameter> getParameters() {
        return this.parameters;
    }

    public PreparedQuery transformQuery(Function<String, String> sqlFunction) {
        return new PreparedQuery(sqlFunction.apply(this.query), this.parameters);
    }
}

