/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.airlift.units.Duration;
import io.trino.plugin.jdbc.CachingJdbcClient;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.statistics.TableStatistics;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class TransactionCachingJdbcClient
extends CachingJdbcClient {
    private final Cache<TableStatisticsCacheKey, TableStatistics> statisticsCache;

    public TransactionCachingJdbcClient(JdbcClient delegate, Duration cachingTtl) {
        super(delegate, Set.of(), cachingTtl, true);
        this.statisticsCache = CacheBuilder.newBuilder().expireAfterWrite(cachingTtl.toMillis(), TimeUnit.MILLISECONDS).build();
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle, TupleDomain<ColumnHandle> tupleDomain) {
        TableStatisticsCacheKey key = new TableStatisticsCacheKey(handle, tupleDomain);
        TableStatistics cachedStatistics = (TableStatistics)this.statisticsCache.getIfPresent((Object)key);
        if (cachedStatistics != null) {
            return cachedStatistics;
        }
        TableStatistics statistics = super.getTableStatistics(session, handle, tupleDomain);
        this.statisticsCache.put((Object)key, (Object)statistics);
        return statistics;
    }

    private static final class TableStatisticsCacheKey {
        private final JdbcTableHandle tableHandle;
        private final TupleDomain<ColumnHandle> tupleDomain;

        private TableStatisticsCacheKey(JdbcTableHandle tableHandle, TupleDomain<ColumnHandle> tupleDomain) {
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
            this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableStatisticsCacheKey that = (TableStatisticsCacheKey)o;
            return Objects.equals(this.tableHandle, that.tableHandle) && Objects.equals(this.tupleDomain, that.tupleDomain);
        }

        public int hashCode() {
            return Objects.hash(this.tableHandle, this.tupleDomain);
        }
    }
}

