/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import io.trino.Session;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public abstract class BaseAutomaticJoinPushdownTest
extends AbstractTestQueryFramework {
    @Test
    public void testJoinPushdownWithEmptyStatsInitially() {
        Session session = this.joinPushdownAutomatic(this.getSession());
        try (TestTable left = this.joinTestTable("left", 200L, 50);
             TestTable right = this.joinTestTable("right", 100L, 100);){
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.maxJoinToTablesRatio(session, 50.0), String.format("SELECT * FROM %s l JOIN %s r ON l.key = r.key", left.getName(), right.getName())))).isNotFullyPushedDown(BaseAutomaticJoinPushdownTest.joinOverTableScans());
            this.gatherStats(left.getName());
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.maxJoinToTablesRatio(session, 50.0), String.format("SELECT * FROM %s l JOIN %s r ON l.key = r.key", left.getName(), right.getName())))).isNotFullyPushedDown(BaseAutomaticJoinPushdownTest.joinOverTableScans());
            this.gatherStats(right.getName());
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.maxJoinToTablesRatio(session, 50.0), String.format("SELECT * FROM %s l JOIN %s r ON l.key = r.key", left.getName(), right.getName())))).isFullyPushedDown();
        }
    }

    @Test
    public void testCrossJoinNoPushdown() {
        Session session = this.joinPushdownAutomatic(this.getSession());
        try (TestTable left = this.joinTestTable("left", 100L, 1);
             TestTable right = this.joinTestTable("right", 10L, 1);){
            this.gatherStats(left.getName());
            this.gatherStats(right.getName());
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.maxJoinToTablesRatio(session, 5.0), String.format("SELECT * FROM %s l JOIN %s r ON l.key = r.key", left.getName(), right.getName())))).isNotFullyPushedDown(BaseAutomaticJoinPushdownTest.joinOverTableScans());
        }
    }

    @Test
    public void testJoinPushdownAutomatic() {
        Session session = this.joinPushdownAutomatic(this.getSession());
        try (TestTable left = this.joinTestTable("left", 600L, 75);
             TestTable right = this.joinTestTable("right", 100L, 100);){
            this.gatherStats(left.getName());
            this.gatherStats(right.getName());
            String simpleJoinQuery = "SELECT * FROM %s l JOIN %s r ON l.key = r.key";
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, String.format(simpleJoinQuery, left.getName(), right.getName())))).isNotFullyPushedDown(BaseAutomaticJoinPushdownTest.joinOverTableScans());
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.maxJoinToTablesRatio(session, 3.0), String.format(simpleJoinQuery, left.getName(), right.getName())))).isFullyPushedDown();
            Session onlySmallTablesAllowed = Session.builder((Session)this.maxJoinToTablesRatio(session, 3.0)).setCatalogSessionProperty((String)session.getCatalog().orElseThrow(), "join_pushdown_automatic_max_table_size", "0.1kB").build();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(onlySmallTablesAllowed, String.format(simpleJoinQuery, left.getName(), right.getName())))).isNotFullyPushedDown(BaseAutomaticJoinPushdownTest.joinOverTableScans());
            String smallJoinOutputQuery = String.format("SELECT l.key FROM %s l JOIN %s r ON l.key = r.key", left.getName(), right.getName());
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, smallJoinOutputQuery))).isFullyPushedDown();
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.maxJoinToTablesRatio(session, 1.0), String.format(simpleJoinQuery, left.getName(), right.getName())))).isNotFullyPushedDown(BaseAutomaticJoinPushdownTest.joinOverTableScans());
        }
    }

    @Test
    public void testAutomaticJoinPushdownOverAggregationPushdown() {
        Session session = this.joinPushdownAutomatic(this.getSession());
        try (TestTable left = this.joinTestTable("left", 100L, 10);
             TestTable right = this.joinTestTable("right", 10L, 5);){
            this.gatherStats(left.getName());
            this.gatherStats(right.getName());
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, String.format("SELECT * FROM %s l JOIN (SELECT DISTINCT key FROM %s) r ON l.key = r.key", left.getName(), right.getName())))).isFullyPushedDown();
        }
    }

    @Test
    public void testAutomaticJoinPushdownTwice() {
        Session session = this.joinPushdownAutomatic(this.getSession());
        try (TestTable first = this.joinTestTable("first", 100L, 100);
             TestTable second = this.joinTestTable("second", 100L, 100);
             TestTable third = this.joinTestTable("third", 100L, 100);){
            this.gatherStats(first.getName());
            this.gatherStats(second.getName());
            this.gatherStats(third.getName());
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, String.format("SELECT * FROM %s first, %s second, %s third WHERE first.key = second.key AND second.key = third.key AND third.intpadding = 42", first.getName(), second.getName(), third.getName())))).isFullyPushedDown();
        }
    }

    protected static PlanMatchPattern joinOverTableScans() {
        return PlanMatchPattern.node(JoinNode.class, (PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])}), PlanMatchPattern.anyTree((PlanMatchPattern[])new PlanMatchPattern[]{PlanMatchPattern.node(TableScanNode.class, (PlanMatchPattern[])new PlanMatchPattern[0])})});
    }

    private TestTable joinTestTable(String name, long rowsCount, int keyDistinctValues) {
        String sourceTable = "tpch.tiny.orders";
        Preconditions.checkArgument((rowsCount < (Long)this.computeScalar("SELECT count(*) FROM " + sourceTable) ? 1 : 0) != 0, (String)"rowsCount too high: %s", (long)rowsCount);
        String padding = Strings.repeat((String)"x", (int)50);
        return new TestTable(this.tableCreator(), name, String.format("(key, padding, intpadding) AS SELECT mod(orderkey, %s), '%s', orderkey FROM %s ORDER BY orderkey LIMIT %s", keyDistinctValues, padding, sourceTable, rowsCount));
    }

    protected SqlExecutor tableCreator() {
        return arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0);
    }

    protected abstract void gatherStats(String var1);

    protected Session joinPushdownAutomatic(Session session) {
        return Session.builder((Session)this.joinPushdownEnabled(session)).setCatalogSessionProperty((String)session.getCatalog().orElseThrow(), "join_pushdown_strategy", "AUTOMATIC").build();
    }

    protected Session joinPushdownEnabled(Session session) {
        Verify.verify((!new JdbcMetadataConfig().isJoinPushdownEnabled() ? 1 : 0) != 0);
        return Session.builder((Session)session).setCatalogSessionProperty((String)session.getCatalog().orElseThrow(), "join_pushdown_enabled", "true").build();
    }

    private Session maxJoinToTablesRatio(Session session, double ratio) {
        return Session.builder((Session)session).setCatalogSessionProperty((String)session.getCatalog().orElseThrow(), "join_pushdown_automatic_max_join_to_tables_ratio", String.valueOf(ratio)).build();
    }
}

