/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import io.airlift.log.Level;
import io.airlift.log.Logging;
import io.trino.plugin.jdbc.mapping.IdentifierMappingModule;
import io.trino.plugin.jdbc.mapping.RuleBasedIdentifierMappingUtils;
import io.trino.plugin.jdbc.mapping.SchemaMappingRule;
import io.trino.plugin.jdbc.mapping.TableMappingRule;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.sql.SqlExecutor;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public abstract class BaseCaseInsensitiveMappingTest
extends AbstractTestQueryFramework {
    protected abstract Path getMappingFile();

    protected abstract SqlExecutor onRemoteDatabase();

    @BeforeClass
    public void disableMappingRefreshVerboseLogging() {
        Logging logging = Logging.initialize();
        logging.setLevel(IdentifierMappingModule.class.getName(), Level.WARN);
    }

    @Test
    public void testNonLowerCaseSchemaName() throws Exception {
        try (AutoCloseable ignore1 = this.withSchema("NonLowerCaseSchema");
             AutoCloseable ignore2 = this.withTable("NonLowerCaseSchema", "lower_case_name", "(c varchar(5))");
             AutoCloseable ignore3 = this.withTable("NonLowerCaseSchema", "Mixed_Case_Name", "(c varchar(5))");
             AutoCloseable ignore4 = this.withTable("NonLowerCaseSchema", "UPPER_CASE_NAME", "(c varchar(5))");){
            Assertions.assertThat((Stream)this.computeActual("SHOW SCHEMAS").getOnlyColumn()).contains(new Object[]{"nonlowercaseschema"});
            this.assertQuery("SHOW SCHEMAS LIKE 'nonlowerc%'", "VALUES 'nonlowercaseschema'");
            this.assertQuery("SELECT schema_name FROM information_schema.schemata WHERE schema_name LIKE '%nonlowercaseschema'", "VALUES 'nonlowercaseschema'");
            this.assertQuery("SHOW TABLES FROM nonlowercaseschema", "VALUES 'lower_case_name', 'mixed_case_name', 'upper_case_name'");
            this.assertQuery("SELECT table_name FROM information_schema.tables WHERE table_schema = 'nonlowercaseschema'", "VALUES 'lower_case_name', 'mixed_case_name', 'upper_case_name'");
            this.assertQueryReturnsEmptyResult("SELECT * FROM nonlowercaseschema.lower_case_name");
        }
    }

    @Test
    public void testNonLowerCaseTableName() throws Exception {
        try (AutoCloseable ignore1 = this.withSchema("SomeSchema");
             AutoCloseable ignore2 = this.withTable("SomeSchema", "NonLowerCaseTable", "(" + this.quoted("lower_case_name") + " varchar(1), " + this.quoted("Mixed_Case_Name") + " varchar(1), " + this.quoted("UPPER_CASE_NAME") + " varchar(1))");){
            this.onRemoteDatabase().execute("INSERT INTO " + this.quoted("SomeSchema") + "." + this.quoted("NonLowerCaseTable") + " SELECT 'a', 'b', 'c'" + this.optionalFromDual().orElse(""));
            this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_schema = 'someschema' AND table_name = 'nonlowercasetable'", "VALUES 'lower_case_name', 'mixed_case_name', 'upper_case_name'");
            this.assertQuery("SELECT column_name FROM information_schema.columns WHERE table_name = 'nonlowercasetable'", "VALUES 'lower_case_name', 'mixed_case_name', 'upper_case_name'");
            Assert.assertEquals((Set)((Set)this.computeActual("SHOW COLUMNS FROM someschema.nonlowercasetable").getMaterializedRows().stream().map(row -> row.getField(0)).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)"lower_case_name", (Object)"mixed_case_name", (Object)"upper_case_name"));
            this.assertQuery("SELECT lower_case_name FROM someschema.nonlowercasetable", "VALUES 'a'");
            this.assertQuery("SELECT mixed_case_name FROM someschema.nonlowercasetable", "VALUES 'b'");
            this.assertQuery("SELECT upper_case_name FROM someschema.nonlowercasetable", "VALUES 'c'");
            this.assertQuery("SELECT upper_case_name FROM SomeSchema.NonLowerCaseTable", "VALUES 'c'");
            this.assertQuery("SELECT upper_case_name FROM \"SomeSchema\".\"NonLowerCaseTable\"", "VALUES 'c'");
            this.assertUpdate("INSERT INTO someschema.nonlowercasetable (lower_case_name) VALUES ('l')", 1L);
            this.assertUpdate("INSERT INTO someschema.nonlowercasetable (mixed_case_name) VALUES ('m')", 1L);
            this.assertUpdate("INSERT INTO someschema.nonlowercasetable (upper_case_name) VALUES ('u')", 1L);
            this.assertQuery("SELECT * FROM someschema.nonlowercasetable", "VALUES ('a', 'b', 'c'),('l', NULL, NULL),(NULL, 'm', NULL),(NULL, NULL, 'u')");
        }
    }

    protected Optional<String> optionalFromDual() {
        return Optional.empty();
    }

    @Test
    public void testSchemaNameClash() throws Exception {
        String[] nameVariants = new String[]{"casesensitivename", "CaseSensitiveName", "CASESENSITIVENAME"};
        Assertions.assertThat((Collection)((Collection)Stream.of(nameVariants).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet()))).hasSize(1);
        for (int i = 0; i < nameVariants.length; ++i) {
            for (int j = i + 1; j < nameVariants.length; ++j) {
                String schemaName = nameVariants[i];
                String otherSchemaName = nameVariants[j];
                try (AutoCloseable ignore1 = this.withSchema(schemaName);
                     AutoCloseable ignore2 = this.withSchema(otherSchemaName);
                     AutoCloseable ignore3 = this.withTable(schemaName, "some_table_name", "(c varchar(5))");
                     AutoCloseable ignore4 = this.withSchema("some_schema");
                     AutoCloseable ignore5 = this.withTable("some_schema", "some_table", "(c int)");){
                    Assertions.assertThat(this.computeActual("SHOW SCHEMAS").getOnlyColumn().filter("casesensitivename"::equals)).hasSize(1);
                    this.assertQueryFails("SHOW TABLES FROM casesensitivename", "Error listing tables for catalog \\w+: Failed to find remote schema name: Ambiguous name: casesensitivename");
                    this.assertQueryFails("SELECT * FROM casesensitivename.some_table_name", "Failed to find remote schema name: Ambiguous name: casesensitivename");
                    this.assertQuery("SHOW TABLES FROM some_schema", "VALUES 'some_table'");
                    this.assertQueryReturnsEmptyResult("SELECT * FROM some_schema.some_table");
                    continue;
                }
            }
        }
    }

    @Test
    public void testTableNameClash() throws Exception {
        String[] nameVariants = new String[]{"casesensitivename", "CaseSensitiveName", "CASESENSITIVENAME"};
        Assertions.assertThat((Collection)((Collection)Stream.of(nameVariants).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet()))).hasSize(1);
        for (int i = 0; i < nameVariants.length; ++i) {
            for (int j = i + 1; j < nameVariants.length; ++j) {
                try (AutoCloseable ignore1 = this.withTable(nameVariants[i], "(c varchar(5))");
                     AutoCloseable ignore2 = this.withTable(nameVariants[j], "(d varchar(5))");
                     AutoCloseable ignore3 = this.withTable("some_table", "(d varchar(5))");){
                    Assertions.assertThat(this.computeActual("SHOW TABLES").getOnlyColumn().filter("casesensitivename"::equals)).hasSize(1);
                    this.assertQueryFails("SHOW COLUMNS FROM casesensitivename", "Failed to find remote table name: Ambiguous name: casesensitivename");
                    this.assertQueryFails("SELECT * FROM casesensitivename", "Failed to find remote table name: Ambiguous name: casesensitivename");
                    this.assertQuery("SHOW COLUMNS FROM some_table", "SELECT 'd', 'varchar(5)', '', ''");
                    this.assertQueryReturnsEmptyResult("SELECT * FROM some_table");
                    continue;
                }
            }
        }
    }

    @Test
    public void testSchemaNameRuleMapping() throws Exception {
        RuleBasedIdentifierMappingUtils.updateRuleBasedIdentifierMappingFile(this.getMappingFile(), (List<SchemaMappingRule>)ImmutableList.of((Object)new SchemaMappingRule("remote_schema", "trino_schema")), (List<TableMappingRule>)ImmutableList.of());
        try (AutoCloseable ignore1 = this.withSchema("remote_schema");
             AutoCloseable ignore3 = this.withTable("remote_schema", "some_table_name", "(c varchar(5))");){
            Assertions.assertThat((Stream)this.computeActual("SHOW SCHEMAS ").getOnlyColumn()).contains(new Object[]{"trino_schema"});
            this.assertQuery("SHOW TABLES FROM trino_schema", "VALUES 'some_table_name'");
            this.assertUpdate("INSERT INTO trino_schema.some_table_name VALUES 'a'", 1L);
            this.assertQuery("SELECT * FROM trino_schema.some_table_name", "VALUES 'a'");
        }
    }

    @Test
    public void testSchemaNameClashWithRuleMapping() throws Exception {
        ImmutableList schemaMappingRules = ImmutableList.of((Object)new SchemaMappingRule("casesensitivename", "casesensitivename_a"), (Object)new SchemaMappingRule("CaseSensitiveName", "casesensitivename_b"), (Object)new SchemaMappingRule("CASESENSITIVENAME", "casesensitivename_c"));
        RuleBasedIdentifierMappingUtils.updateRuleBasedIdentifierMappingFile(this.getMappingFile(), (List<SchemaMappingRule>)schemaMappingRules, (List<TableMappingRule>)ImmutableList.of());
        String[] nameVariants = new String[]{"casesensitivename", "CaseSensitiveName", "CASESENSITIVENAME"};
        Assertions.assertThat((Collection)((Collection)Stream.of(nameVariants).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet()))).hasSize(1);
        for (int i = 0; i < nameVariants.length; ++i) {
            for (int j = i + 1; j < nameVariants.length; ++j) {
                String remoteSchema = nameVariants[i];
                String otherRemoteSchema = nameVariants[j];
                try (AutoCloseable ignore1 = this.withSchema(remoteSchema);
                     AutoCloseable ignore2 = this.withSchema(otherRemoteSchema);
                     AutoCloseable ignore3 = this.withTable(remoteSchema, "some_table_name", "(c varchar(5))");){
                    String schema = (String)schemaMappingRules.stream().filter(rule -> rule.getRemoteSchema().equals(remoteSchema)).map(SchemaMappingRule::getMapping).collect(MoreCollectors.onlyElement());
                    Assertions.assertThat(this.computeActual("SHOW SCHEMAS ").getOnlyColumn().map(String.class::cast).filter(anObject -> anObject.startsWith("casesensitivename"))).hasSize(2);
                    this.assertQuery("SHOW TABLES FROM " + schema, "VALUES 'some_table_name'");
                    this.assertUpdate(String.format("INSERT INTO %s.some_table_name VALUES 'a'", schema), 1L);
                    this.assertQuery(String.format("SELECT * FROM %s.some_table_name", schema), "VALUES 'a'");
                    continue;
                }
            }
        }
    }

    @Test
    public void testTableNameRuleMapping() throws Exception {
        String schema = "remote_schema";
        RuleBasedIdentifierMappingUtils.updateRuleBasedIdentifierMappingFile(this.getMappingFile(), (List<SchemaMappingRule>)ImmutableList.of(), (List<TableMappingRule>)ImmutableList.of((Object)new TableMappingRule(schema, "remote_table", "trino_table")));
        try (AutoCloseable ignore = this.withSchema(schema);
             AutoCloseable ignore1 = this.withTable(schema, "remote_table", "(c varchar(5))");){
            Assertions.assertThat((Stream)this.computeActual("SHOW TABLES FROM " + schema).getOnlyColumn()).contains(new Object[]{"trino_table"});
            this.assertQuery("SHOW COLUMNS FROM " + schema + ".trino_table", "SELECT 'c', 'varchar(5)', '', ''");
            this.assertUpdate("INSERT INTO " + schema + ".trino_table VALUES 'dane'", 1L);
            this.assertQuery("SELECT * FROM " + schema + ".trino_table", "VALUES 'dane'");
        }
    }

    @Test
    public void testTableNameClashWithRuleMapping() throws Exception {
        String schema = "remote_schema";
        ImmutableList tableMappingRules = ImmutableList.of((Object)new TableMappingRule(schema, "casesensitivename", "casesensitivename_a"), (Object)new TableMappingRule(schema, "CaseSensitiveName", "casesensitivename_b"), (Object)new TableMappingRule(schema, "CASESENSITIVENAME", "casesensitivename_c"));
        RuleBasedIdentifierMappingUtils.updateRuleBasedIdentifierMappingFile(this.getMappingFile(), (List<SchemaMappingRule>)ImmutableList.of(), (List<TableMappingRule>)tableMappingRules);
        String[] nameVariants = new String[]{"casesensitivename", "CaseSensitiveName", "CASESENSITIVENAME"};
        Assertions.assertThat((Collection)((Collection)Stream.of(nameVariants).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet()))).hasSize(1);
        for (int i = 0; i < nameVariants.length; ++i) {
            for (int j = i + 1; j < nameVariants.length; ++j) {
                String remoteTable = nameVariants[i];
                String otherRemoteTable = nameVariants[j];
                try (AutoCloseable ignore = this.withSchema(schema);
                     AutoCloseable ignore1 = this.withTable(schema, remoteTable, "(c varchar(5))");
                     AutoCloseable ignore2 = this.withTable(schema, otherRemoteTable, "(d varchar(5))");){
                    String table = (String)tableMappingRules.stream().filter(rule -> rule.getRemoteTable().equals(remoteTable)).map(TableMappingRule::getMapping).collect(MoreCollectors.onlyElement());
                    Assertions.assertThat(this.computeActual("SHOW TABLES FROM " + schema).getOnlyColumn().map(String.class::cast).filter(anObject -> anObject.startsWith("casesensitivename"))).hasSize(2);
                    this.assertQuery("SHOW COLUMNS FROM " + schema + "." + table, "SELECT 'c', 'varchar(5)', '', ''");
                    this.assertUpdate("INSERT INTO " + schema + "." + table + " VALUES 'dane'", 1L);
                    this.assertQuery("SELECT * FROM " + schema + "." + table, "VALUES 'dane'");
                    continue;
                }
            }
        }
    }

    @Test
    public void testSchemaAndTableNameRuleMapping() throws Exception {
        RuleBasedIdentifierMappingUtils.updateRuleBasedIdentifierMappingFile(this.getMappingFile(), (List<SchemaMappingRule>)ImmutableList.of((Object)new SchemaMappingRule("remote_schema", "trino_schema")), (List<TableMappingRule>)ImmutableList.of((Object)new TableMappingRule("remote_schema", "remote_table", "trino_table")));
        try (AutoCloseable ignore1 = this.withSchema("remote_schema");
             AutoCloseable ignore2 = this.withTable("remote_schema", "remote_table", "(c varchar(5))");){
            Assertions.assertThat((Stream)this.computeActual("SHOW SCHEMAS").getOnlyColumn()).contains(new Object[]{"trino_schema"});
            Assertions.assertThat((Stream)this.computeActual("SHOW TABLES IN trino_schema").getOnlyColumn()).contains(new Object[]{"trino_table"});
            this.assertQuery("SHOW COLUMNS FROM trino_schema.trino_table", "SELECT 'c', 'varchar(5)', '', ''");
            this.assertUpdate("INSERT INTO trino_schema.trino_table VALUES 'dane'", 1L);
            this.assertQuery("SELECT * FROM trino_schema.trino_table", "VALUES 'dane'");
        }
    }

    protected AutoCloseable withSchema(String schemaName) {
        this.onRemoteDatabase().execute("CREATE SCHEMA " + this.quoted(schemaName));
        return () -> this.onRemoteDatabase().execute("DROP SCHEMA " + this.quoted(schemaName));
    }

    protected AutoCloseable withTable(String remoteSchemaName, String remoteTableName, String tableDefinition) {
        String quotedName = this.quoted(remoteSchemaName) + "." + this.quoted(remoteTableName);
        this.onRemoteDatabase().execute(String.format("CREATE TABLE %s %s", quotedName, tableDefinition));
        return () -> this.onRemoteDatabase().execute("DROP TABLE " + quotedName);
    }

    protected String quoted(String name) {
        String identifierQuote = "\"";
        name = name.replace(identifierQuote, identifierQuote + identifierQuote);
        return identifierQuote + name + identifierQuote;
    }

    private AutoCloseable withTable(String remoteTableName, String definition) {
        return this.withTable((String)this.getSession().getSchema().orElseThrow(), remoteTableName, definition);
    }
}

