/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.trino.operator.RetryPolicy;
import io.trino.testing.BaseFailureRecoveryTest;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.SkipException;

public abstract class BaseJdbcFailureRecoveryTest
extends BaseFailureRecoveryTest {
    public BaseJdbcFailureRecoveryTest(RetryPolicy retryPolicy) {
        super(retryPolicy);
    }

    protected void testAnalyzeTable() {
        Assertions.assertThatThrownBy(() -> super.testAnalyzeTable()).hasMessageMatching("This connector does not support analyze");
        throw new SkipException("skipped");
    }

    protected void testDelete() {
        Optional<String> setupQuery = Optional.of("CREATE TABLE <table> AS SELECT * FROM orders");
        String testQuery = "DELETE FROM <table> WHERE orderkey = 1";
        Optional<String> cleanupQuery = Optional.of("DROP TABLE <table>");
        this.assertThatQuery(testQuery).withSetupQuery(setupQuery).withCleanupQuery(cleanupQuery).isCoordinatorOnly();
    }

    protected void testDeleteWithSubquery() {
        Assertions.assertThatThrownBy(() -> super.testDeleteWithSubquery()).hasMessageContaining("This connector does not support modifying table rows");
        throw new SkipException("skipped");
    }

    protected void testRefreshMaterializedView() {
        Assertions.assertThatThrownBy(() -> super.testRefreshMaterializedView()).hasMessageContaining("This connector does not support creating materialized views");
        throw new SkipException("skipped");
    }

    protected void testUpdate() {
        Assertions.assertThatThrownBy(() -> super.testUpdate()).hasMessageContaining("This connector does not support modifying table rows");
        throw new SkipException("skipped");
    }

    protected void testUpdateWithSubquery() {
        Assertions.assertThatThrownBy(() -> super.testUpdateWithSubquery()).hasMessageContaining("This connector does not support modifying table rows");
        throw new SkipException("skipped");
    }

    protected void testMerge() {
        Assertions.assertThatThrownBy(() -> super.testMerge()).hasMessageContaining("This connector does not support modifying table rows");
        throw new SkipException("skipped");
    }

    protected boolean areWriteRetriesSupported() {
        return true;
    }
}

