/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.trino.plugin.jdbc.DefaultJdbcMetadata;
import io.trino.plugin.jdbc.ForwardingJdbcClient;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.JdbcMetadataSessionProperties;
import io.trino.plugin.jdbc.JdbcQueryRelationHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.TestingDatabase;
import io.trino.plugin.jdbc.TestingJdbcTypeHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDefaultJdbcMetadata {
    private TestingDatabase database;
    private DefaultJdbcMetadata metadata;
    private JdbcTableHandle tableHandle;

    @BeforeMethod
    public void setUp() throws Exception {
        this.database = new TestingDatabase();
        this.metadata = new DefaultJdbcMetadata((JdbcClient)new GroupingSetsEnabledJdbcClient(this.database.getJdbcClient(), Optional.empty()), false, (Set)ImmutableSet.of());
        this.tableHandle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("example", "numbers"));
    }

    @Test
    public void testSupportsRetriesValidation() {
        this.metadata = new DefaultJdbcMetadata((JdbcClient)new GroupingSetsEnabledJdbcClient(this.database.getJdbcClient(), Optional.of(false)), false, (Set)ImmutableSet.of());
        ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(new SchemaTableName("example", "numbers"), (List)ImmutableList.of());
        Assertions.assertThatThrownBy(() -> this.metadata.beginCreateTable(TestingConnectorSession.SESSION, tableMetadata, Optional.empty(), RetryMode.RETRIES_ENABLED)).hasMessageContaining("This connector does not support query or task retries");
        Assertions.assertThatThrownBy(() -> this.metadata.beginInsert(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle, (List)ImmutableList.of(), RetryMode.RETRIES_ENABLED)).hasMessageContaining("This connector does not support query or task retries");
    }

    @Test
    public void testNonTransactionalInsertValidation() {
        this.metadata = new DefaultJdbcMetadata((JdbcClient)new GroupingSetsEnabledJdbcClient(this.database.getJdbcClient(), Optional.of(true)), false, (Set)ImmutableSet.of());
        ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(new SchemaTableName("example", "numbers"), (List)ImmutableList.of());
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata((List)ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)"non_transactional_insert", (String)"description", (Boolean)true, (boolean)false))).build();
        Assertions.assertThatThrownBy(() -> this.lambda$testNonTransactionalInsertValidation$2((ConnectorSession)session, tableMetadata)).hasMessageContaining("Query and task retries are incompatible with non-transactional inserts");
        Assertions.assertThatThrownBy(() -> this.lambda$testNonTransactionalInsertValidation$3((ConnectorSession)session)).hasMessageContaining("Query and task retries are incompatible with non-transactional inserts");
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.database.close();
        this.database = null;
    }

    @Test
    public void testListSchemaNames() {
        Assert.assertTrue((boolean)this.metadata.listSchemaNames(TestingConnectorSession.SESSION).containsAll((Collection<?>)ImmutableSet.of((Object)"example", (Object)"tpch")));
    }

    @Test
    public void testGetTableHandle() {
        JdbcTableHandle tableHandle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("example", "numbers"));
        Assert.assertEquals((Object)this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("example", "numbers")), (Object)tableHandle);
        Assert.assertNull((Object)this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("example", "unknown")));
        Assert.assertNull((Object)this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("unknown", "numbers")));
        Assert.assertNull((Object)this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("unknown", "unknown")));
    }

    @Test
    public void testGetColumnHandles() {
        Assert.assertEquals((Map)this.metadata.getColumnHandles(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle), (Map)ImmutableMap.of((Object)"text", (Object)new JdbcColumnHandle("TEXT", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), (Object)"text_short", (Object)new JdbcColumnHandle("TEXT_SHORT", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.createVarcharType((int)32)), (Object)"value", (Object)new JdbcColumnHandle("VALUE", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT)));
        this.unknownTableColumnHandle(new JdbcTableHandle(new SchemaTableName("unknown", "unknown"), new RemoteTableName(Optional.of("unknown"), Optional.of("unknown"), "unknown"), Optional.empty()));
        this.unknownTableColumnHandle(new JdbcTableHandle(new SchemaTableName("example", "numbers"), new RemoteTableName(Optional.empty(), Optional.of("example"), "unknown"), Optional.empty()));
    }

    private void unknownTableColumnHandle(JdbcTableHandle tableHandle) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.metadata.getColumnHandles(TestingConnectorSession.SESSION, (ConnectorTableHandle)tableHandle)).isInstanceOf(TableNotFoundException.class)).hasMessage("Table '%s' has no supported columns (all 0 columns are not supported)", new Object[]{tableHandle.asPlainTable().getSchemaTableName()});
    }

    @Test
    public void getTableMetadata() {
        ConnectorTableMetadata tableMetadata = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle);
        Assert.assertEquals((Object)tableMetadata.getTable(), (Object)new SchemaTableName("example", "numbers"));
        Assert.assertEquals((Collection)tableMetadata.getColumns(), (Collection)ImmutableList.of((Object)ColumnMetadata.builder().setName("text").setType((Type)VarcharType.VARCHAR).setNullable(false).build(), (Object)new ColumnMetadata("text_short", (Type)VarcharType.createVarcharType((int)32)), (Object)new ColumnMetadata("value", (Type)BigintType.BIGINT)));
        JdbcTableHandle specialTableHandle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("exa_ple", "num_ers"));
        ConnectorTableMetadata specialTableMetadata = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)specialTableHandle);
        Assert.assertEquals((Object)specialTableMetadata.getTable(), (Object)new SchemaTableName("exa_ple", "num_ers"));
        Assert.assertEquals((Collection)specialTableMetadata.getColumns(), (Collection)ImmutableList.of((Object)ColumnMetadata.builder().setName("te_t").setType((Type)VarcharType.VARCHAR).setNullable(false).build(), (Object)new ColumnMetadata("va%ue", (Type)BigintType.BIGINT)));
        this.unknownTableMetadata(new JdbcTableHandle(new SchemaTableName("u", "numbers"), new RemoteTableName(Optional.empty(), Optional.of("unknown"), "unknown"), Optional.empty()));
        this.unknownTableMetadata(new JdbcTableHandle(new SchemaTableName("example", "numbers"), new RemoteTableName(Optional.empty(), Optional.of("example"), "unknown"), Optional.empty()));
        this.unknownTableMetadata(new JdbcTableHandle(new SchemaTableName("example", "numbers"), new RemoteTableName(Optional.empty(), Optional.of("unknown"), "numbers"), Optional.empty()));
    }

    private void unknownTableMetadata(JdbcTableHandle tableHandle) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)tableHandle)).isInstanceOf(TableNotFoundException.class)).hasMessage("Table '%s' has no supported columns (all 0 columns are not supported)", new Object[]{tableHandle.asPlainTable().getSchemaTableName()});
    }

    @Test
    public void testListTables() {
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.empty())), (Set)ImmutableSet.of((Object)new SchemaTableName("example", "numbers"), (Object)new SchemaTableName("example", "timestamps"), (Object)new SchemaTableName("example", "view_source"), (Object)new SchemaTableName("example", "view"), (Object)new SchemaTableName("tpch", "orders"), (Object)new SchemaTableName("tpch", "lineitem"), (Object[])new SchemaTableName[]{new SchemaTableName("exa_ple", "table_with_float_col"), new SchemaTableName("exa_ple", "num_ers")}));
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("example"))), (Set)ImmutableSet.of((Object)new SchemaTableName("example", "numbers"), (Object)new SchemaTableName("example", "timestamps"), (Object)new SchemaTableName("example", "view_source"), (Object)new SchemaTableName("example", "view")));
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("tpch"))), (Set)ImmutableSet.of((Object)new SchemaTableName("tpch", "orders"), (Object)new SchemaTableName("tpch", "lineitem")));
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("exa_ple"))), (Set)ImmutableSet.of((Object)new SchemaTableName("exa_ple", "num_ers"), (Object)new SchemaTableName("exa_ple", "table_with_float_col")));
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("unknown"))), (Set)ImmutableSet.of());
    }

    @Test
    public void getColumnMetadata() {
        Assert.assertEquals((Object)this.metadata.getColumnMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle, (ColumnHandle)new JdbcColumnHandle("text", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR)), (Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR));
    }

    @Test
    public void testCreateAndAlterTable() {
        SchemaTableName table = new SchemaTableName("example", "foo");
        this.metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(table, (List)ImmutableList.of((Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR))), false);
        JdbcTableHandle handle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, table);
        ConnectorTableMetadata layout = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle);
        Assert.assertEquals((Object)layout.getTable(), (Object)table);
        Assert.assertEquals((int)layout.getColumns().size(), (int)1);
        Assert.assertEquals(layout.getColumns().get(0), (Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR));
        this.metadata.addColumn(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle, new ColumnMetadata("x", (Type)VarcharType.VARCHAR));
        layout = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle);
        Assert.assertEquals((int)layout.getColumns().size(), (int)2);
        Assert.assertEquals(layout.getColumns().get(0), (Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR));
        Assert.assertEquals(layout.getColumns().get(1), (Object)new ColumnMetadata("x", (Type)VarcharType.VARCHAR));
        JdbcColumnHandle columnHandle = new JdbcColumnHandle("x", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR);
        this.metadata.dropColumn(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle, (ColumnHandle)columnHandle);
        layout = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle);
        Assert.assertEquals((int)layout.getColumns().size(), (int)1);
        Assert.assertEquals(layout.getColumns().get(0), (Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR));
        SchemaTableName newTableName = new SchemaTableName("example", "bar");
        this.metadata.renameTable(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle, newTableName);
        handle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, newTableName);
        layout = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle);
        Assert.assertEquals((Object)layout.getTable(), (Object)newTableName);
        Assert.assertEquals((int)layout.getColumns().size(), (int)1);
        Assert.assertEquals(layout.getColumns().get(0), (Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR));
    }

    @Test
    public void testDropTableTable() {
        this.metadata.dropTable(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_FOUND});
    }

    @Test
    public void testAggregationPushdownForTableHandle() {
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig().setAggregationPushdownEnabled(true), Optional.empty()).getSessionProperties()).build();
        ColumnHandle groupByColumn = (ColumnHandle)this.metadata.getColumnHandles((ConnectorSession)session, (ConnectorTableHandle)this.tableHandle).get("text");
        Function<ConnectorTableHandle, Optional> applyAggregation = arg_0 -> this.lambda$testAggregationPushdownForTableHandle$7((ConnectorSession)session, groupByColumn, arg_0);
        JdbcTableHandle baseTableHandle = this.metadata.getTableHandle((ConnectorSession)session, new SchemaTableName("example", "numbers"));
        Optional aggregationResult = applyAggregation.apply((ConnectorTableHandle)baseTableHandle);
        Assertions.assertThat((Optional)aggregationResult).isPresent();
        SchemaTableName noAggregationPushdownTable = new SchemaTableName("example", "no_aggregation_pushdown");
        this.metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(noAggregationPushdownTable, (List)ImmutableList.of((Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR))), false);
        JdbcTableHandle noAggregationPushdownTableHandle = this.metadata.getTableHandle((ConnectorSession)session, noAggregationPushdownTable);
        aggregationResult = applyAggregation.apply((ConnectorTableHandle)noAggregationPushdownTableHandle);
        Assertions.assertThat((Optional)aggregationResult).isEmpty();
    }

    @Test
    public void testApplyFilterAfterAggregationPushdown() {
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig().setAggregationPushdownEnabled(true), Optional.empty()).getSessionProperties()).build();
        ColumnHandle groupByColumn = (ColumnHandle)this.metadata.getColumnHandles((ConnectorSession)session, (ConnectorTableHandle)this.tableHandle).get("text");
        JdbcTableHandle baseTableHandle = this.metadata.getTableHandle((ConnectorSession)session, new SchemaTableName("example", "numbers"));
        JdbcTableHandle aggregatedTable = this.applyCountAggregation((ConnectorSession)session, (ConnectorTableHandle)baseTableHandle, (List<List<ColumnHandle>>)ImmutableList.of((Object)ImmutableList.of((Object)groupByColumn)));
        Domain domain = Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"one"));
        JdbcTableHandle tableHandleWithFilter = this.applyFilter((ConnectorSession)session, (ConnectorTableHandle)aggregatedTable, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)groupByColumn, (Object)domain))));
        Assert.assertEquals((Object)tableHandleWithFilter.getConstraint().getDomains(), Optional.of(ImmutableMap.of((Object)groupByColumn, (Object)domain)));
    }

    @Test
    public void testCombineFiltersWithAggregationPushdown() {
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig().setAggregationPushdownEnabled(true), Optional.empty()).getSessionProperties()).build();
        ColumnHandle groupByColumn = (ColumnHandle)this.metadata.getColumnHandles((ConnectorSession)session, (ConnectorTableHandle)this.tableHandle).get("text");
        JdbcTableHandle baseTableHandle = this.metadata.getTableHandle((ConnectorSession)session, new SchemaTableName("example", "numbers"));
        Domain firstDomain = Domain.multipleValues((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"one"), (Object)Slices.utf8Slice((String)"two")));
        JdbcTableHandle filterResult = this.applyFilter((ConnectorSession)session, (ConnectorTableHandle)baseTableHandle, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)groupByColumn, (Object)firstDomain))));
        JdbcTableHandle aggregatedTable = this.applyCountAggregation((ConnectorSession)session, (ConnectorTableHandle)filterResult, (List<List<ColumnHandle>>)ImmutableList.of((Object)ImmutableList.of((Object)groupByColumn)));
        Domain secondDomain = Domain.multipleValues((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"one"), (Object)Slices.utf8Slice((String)"three")));
        JdbcTableHandle tableHandleWithFilter = this.applyFilter((ConnectorSession)session, (ConnectorTableHandle)aggregatedTable, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)groupByColumn, (Object)secondDomain))));
        Assert.assertEquals((Object)tableHandleWithFilter.getConstraint().getDomains(), Optional.of(ImmutableMap.of((Object)groupByColumn, (Object)secondDomain)));
        Assert.assertEquals((String)((JdbcQueryRelationHandle)tableHandleWithFilter.getRelationHandle()).getPreparedQuery().getQuery(), (String)("SELECT \"TEXT\", count(*) AS \"_pfgnrtd_0\" FROM \"" + this.database.getDatabaseName() + "\".\"EXAMPLE\".\"NUMBERS\" WHERE \"TEXT\" IN (?,?) GROUP BY \"TEXT\""));
    }

    @Test
    public void testNonGroupKeyPredicatePushdown() {
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig().setAggregationPushdownEnabled(true), Optional.empty()).getSessionProperties()).build();
        Map columnHandles = this.metadata.getColumnHandles((ConnectorSession)session, (ConnectorTableHandle)this.tableHandle);
        ColumnHandle groupByColumn = (ColumnHandle)columnHandles.get("text");
        ColumnHandle nonGroupByColumn = (ColumnHandle)columnHandles.get("value");
        JdbcTableHandle baseTableHandle = this.metadata.getTableHandle((ConnectorSession)session, new SchemaTableName("example", "numbers"));
        JdbcTableHandle aggregatedTable = this.applyCountAggregation((ConnectorSession)session, (ConnectorTableHandle)baseTableHandle, (List<List<ColumnHandle>>)ImmutableList.of((Object)ImmutableList.of((Object)groupByColumn)));
        Domain domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)123L);
        JdbcTableHandle tableHandleWithFilter = this.applyFilter((ConnectorSession)session, (ConnectorTableHandle)aggregatedTable, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)nonGroupByColumn, (Object)domain))));
        Assert.assertEquals((Object)tableHandleWithFilter.getConstraint().getDomains(), Optional.of(ImmutableMap.of((Object)nonGroupByColumn, (Object)domain)));
        Assert.assertEquals((String)((JdbcQueryRelationHandle)tableHandleWithFilter.getRelationHandle()).getPreparedQuery().getQuery(), (String)("SELECT \"TEXT\", count(*) AS \"_pfgnrtd_0\" FROM \"" + this.database.getDatabaseName() + "\".\"EXAMPLE\".\"NUMBERS\" GROUP BY \"TEXT\""));
    }

    @Test
    public void testMultiGroupKeyPredicatePushdown() {
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig().setAggregationPushdownEnabled(true), Optional.empty()).getSessionProperties()).build();
        Map columnHandles = this.metadata.getColumnHandles((ConnectorSession)session, (ConnectorTableHandle)this.tableHandle);
        ColumnHandle textColumn = (ColumnHandle)columnHandles.get("text");
        ColumnHandle valueColumn = (ColumnHandle)columnHandles.get("value");
        JdbcTableHandle baseTableHandle = this.metadata.getTableHandle((ConnectorSession)session, new SchemaTableName("example", "numbers"));
        JdbcTableHandle aggregatedTable = this.applyCountAggregation((ConnectorSession)session, (ConnectorTableHandle)baseTableHandle, (List<List<ColumnHandle>>)ImmutableList.of((Object)ImmutableList.of((Object)textColumn, (Object)valueColumn), (Object)ImmutableList.of((Object)textColumn)));
        Domain domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)123L);
        JdbcTableHandle tableHandleWithFilter = this.applyFilter((ConnectorSession)session, (ConnectorTableHandle)aggregatedTable, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)valueColumn, (Object)domain))));
        Assert.assertEquals((Object)tableHandleWithFilter.getConstraint().getDomains(), Optional.of(ImmutableMap.of((Object)valueColumn, (Object)domain)));
        Assert.assertEquals((String)((JdbcQueryRelationHandle)tableHandleWithFilter.getRelationHandle()).getPreparedQuery().getQuery(), (String)("SELECT \"TEXT\", \"VALUE\", count(*) AS \"_pfgnrtd_0\" FROM \"" + this.database.getDatabaseName() + "\".\"EXAMPLE\".\"NUMBERS\" GROUP BY GROUPING SETS ((\"TEXT\", \"VALUE\"), (\"TEXT\"))"));
    }

    private JdbcTableHandle applyCountAggregation(ConnectorSession session, ConnectorTableHandle tableHandle, List<List<ColumnHandle>> groupByColumns) {
        Optional aggResult = this.metadata.applyAggregation(session, tableHandle, (List)ImmutableList.of((Object)new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(), List.of(), false, Optional.empty())), (Map)ImmutableMap.of(), groupByColumns);
        Assertions.assertThat((Optional)aggResult).isPresent();
        return (JdbcTableHandle)((AggregationApplicationResult)aggResult.get()).getHandle();
    }

    private JdbcTableHandle applyFilter(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        Optional filterResult = this.metadata.applyFilter(session, tableHandle, constraint);
        Assertions.assertThat((Optional)filterResult).isPresent();
        return (JdbcTableHandle)((ConstraintApplicationResult)filterResult.get()).getHandle();
    }

    private /* synthetic */ Optional lambda$testAggregationPushdownForTableHandle$7(ConnectorSession session, ColumnHandle groupByColumn, ConnectorTableHandle handle) {
        return this.metadata.applyAggregation(session, handle, (List)ImmutableList.of((Object)new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(), List.of(), false, Optional.empty())), (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)ImmutableList.of((Object)groupByColumn)));
    }

    private /* synthetic */ void lambda$testNonTransactionalInsertValidation$3(ConnectorSession session) throws Throwable {
        this.metadata.beginInsert(session, (ConnectorTableHandle)this.tableHandle, (List)ImmutableList.of(), RetryMode.RETRIES_ENABLED);
    }

    private /* synthetic */ void lambda$testNonTransactionalInsertValidation$2(ConnectorSession session, ConnectorTableMetadata tableMetadata) throws Throwable {
        this.metadata.beginCreateTable(session, tableMetadata, Optional.empty(), RetryMode.RETRIES_ENABLED);
    }

    private static class GroupingSetsEnabledJdbcClient
    extends ForwardingJdbcClient {
        private final JdbcClient delegate;
        private final Optional<Boolean> supportsRetriesOverride;

        public GroupingSetsEnabledJdbcClient(JdbcClient jdbcClient, Optional<Boolean> supportsRetriesOverride) {
            this.delegate = jdbcClient;
            this.supportsRetriesOverride = supportsRetriesOverride;
        }

        protected JdbcClient delegate() {
            return this.delegate;
        }

        public boolean supportsRetries() {
            return this.supportsRetriesOverride.orElseGet(() -> super.supportsRetries());
        }

        public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
            return !"no_aggregation_pushdown".equalsIgnoreCase(table.getRequiredNamedRelation().getRemoteTableName().getTableName());
        }
    }
}

