/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.TestingDatabase;
import io.trino.plugin.jdbc.TestingJdbcTypeHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingSession;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJdbcClient {
    private static final ConnectorSession session = TestingSession.testSessionBuilder().build().toConnectorSession();
    private TestingDatabase database;
    private String catalogName;
    private JdbcClient jdbcClient;

    @BeforeClass
    public void setUp() throws Exception {
        this.database = new TestingDatabase();
        this.catalogName = this.database.getConnection().getCatalog();
        this.jdbcClient = this.database.getJdbcClient();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.database.close();
        this.database = null;
    }

    @Test
    public void testMetadata() {
        Assert.assertTrue((boolean)this.jdbcClient.getSchemaNames(session).containsAll((Collection<?>)ImmutableSet.of((Object)"example", (Object)"tpch")));
        Assert.assertEquals((Collection)this.jdbcClient.getTableNames(session, Optional.of("example")), (Collection)ImmutableList.of((Object)new SchemaTableName("example", "numbers"), (Object)new SchemaTableName("example", "timestamps"), (Object)new SchemaTableName("example", "view_source"), (Object)new SchemaTableName("example", "view")));
        Assert.assertEquals((Collection)this.jdbcClient.getTableNames(session, Optional.of("tpch")), (Collection)ImmutableList.of((Object)new SchemaTableName("tpch", "lineitem"), (Object)new SchemaTableName("tpch", "orders")));
        SchemaTableName schemaTableName = new SchemaTableName("example", "numbers");
        Optional table = this.jdbcClient.getTableHandle(session, schemaTableName);
        Assert.assertTrue((boolean)table.isPresent(), (String)"table is missing");
        Assert.assertEquals((String)((JdbcTableHandle)table.get()).getRequiredNamedRelation().getRemoteTableName().getCatalogName().orElse(null), (String)this.catalogName.toUpperCase(Locale.ENGLISH));
        Assert.assertEquals((String)((JdbcTableHandle)table.get()).getRequiredNamedRelation().getRemoteTableName().getSchemaName().orElse(null), (String)"EXAMPLE");
        Assert.assertEquals((String)((JdbcTableHandle)table.get()).getRequiredNamedRelation().getRemoteTableName().getTableName(), (String)"NUMBERS");
        Assert.assertEquals((Object)((JdbcTableHandle)table.get()).getRequiredNamedRelation().getSchemaTableName(), (Object)schemaTableName);
        Assert.assertEquals((Collection)this.jdbcClient.getColumns(session, (JdbcTableHandle)table.orElse(null)), (Collection)ImmutableList.of((Object)new JdbcColumnHandle("TEXT", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), (Object)new JdbcColumnHandle("TEXT_SHORT", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.createVarcharType((int)32)), (Object)new JdbcColumnHandle("VALUE", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT)));
    }

    @Test
    public void testMetadataWithSchemaPattern() {
        SchemaTableName schemaTableName = new SchemaTableName("exa_ple", "num_ers");
        Optional table = this.jdbcClient.getTableHandle(session, schemaTableName);
        Assert.assertTrue((boolean)table.isPresent(), (String)"table is missing");
        Assert.assertEquals((Collection)this.jdbcClient.getColumns(session, (JdbcTableHandle)table.get()), (Collection)ImmutableList.of((Object)new JdbcColumnHandle("TE_T", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), (Object)new JdbcColumnHandle("VA%UE", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT)));
    }

    @Test
    public void testMetadataWithFloatAndDoubleCol() {
        SchemaTableName schemaTableName = new SchemaTableName("exa_ple", "table_with_float_col");
        Optional table = this.jdbcClient.getTableHandle(session, schemaTableName);
        Assert.assertTrue((boolean)table.isPresent(), (String)"table is missing");
        Assert.assertEquals((Collection)this.jdbcClient.getColumns(session, (JdbcTableHandle)table.get()), (Collection)ImmutableList.of((Object)new JdbcColumnHandle("COL1", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT), (Object)new JdbcColumnHandle("COL2", TestingJdbcTypeHandle.JDBC_DOUBLE, (Type)DoubleType.DOUBLE), (Object)new JdbcColumnHandle("COL3", TestingJdbcTypeHandle.JDBC_DOUBLE, (Type)DoubleType.DOUBLE), (Object)new JdbcColumnHandle("COL4", TestingJdbcTypeHandle.JDBC_REAL, (Type)RealType.REAL)));
    }

    @Test
    public void testMetadataWithTimestampCol() {
        SchemaTableName schemaTableName = new SchemaTableName("example", "timestamps");
        Optional table = this.jdbcClient.getTableHandle(session, schemaTableName);
        Assert.assertTrue((boolean)table.isPresent(), (String)"table is missing");
        Assert.assertEquals((Collection)this.jdbcClient.getColumns(session, (JdbcTableHandle)table.get()), (Collection)ImmutableList.of((Object)new JdbcColumnHandle("TS_3", TestingJdbcTypeHandle.JDBC_TIMESTAMP, (Type)TimestampType.TIMESTAMP_MILLIS), (Object)new JdbcColumnHandle("TS_6", TestingJdbcTypeHandle.JDBC_TIMESTAMP, (Type)TimestampType.TIMESTAMP_MICROS), (Object)new JdbcColumnHandle("TS_9", TestingJdbcTypeHandle.JDBC_TIMESTAMP, (Type)TimestampType.TIMESTAMP_NANOS)));
    }

    @Test
    public void testCreateSchema() {
        String schemaName = "test schema";
        this.jdbcClient.createSchema(session, schemaName);
        Assertions.assertThat((Collection)this.jdbcClient.getSchemaNames(session)).contains((Object[])new String[]{schemaName});
        this.jdbcClient.dropSchema(session, schemaName);
        Assertions.assertThat((Collection)this.jdbcClient.getSchemaNames(session)).doesNotContain((Object[])new String[]{schemaName});
    }

    @Test
    public void testRenameTable() {
        String schemaName = "test_schema";
        SchemaTableName oldTable = new SchemaTableName(schemaName, "foo");
        SchemaTableName newTable = new SchemaTableName(schemaName, "bar");
        ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(oldTable, (List)ImmutableList.of((Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR)));
        this.jdbcClient.createSchema(session, schemaName);
        this.jdbcClient.createTable(session, tableMetadata);
        this.jdbcClient.renameTable(session, (JdbcTableHandle)this.jdbcClient.getTableHandle(session, oldTable).get(), newTable);
        this.jdbcClient.dropTable(session, (JdbcTableHandle)this.jdbcClient.getTableHandle(session, newTable).get());
        this.jdbcClient.dropSchema(session, schemaName);
        ((ListAssert)Assertions.assertThat((List)this.jdbcClient.getTableNames(session, Optional.empty())).doesNotContain((Object[])new SchemaTableName[]{oldTable})).doesNotContain((Object[])new SchemaTableName[]{newTable});
        Assertions.assertThat((Collection)this.jdbcClient.getSchemaNames(session)).doesNotContain((Object[])new String[]{schemaName});
    }
}

