/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BaseJdbcConnectionCreationTest;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.H2QueryRunner;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.TestingH2JdbcClient;
import io.trino.plugin.jdbc.TestingH2JdbcModule;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.credential.EmptyCredentialProvider;
import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.h2.Driver;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestJdbcConnectionCreation
extends BaseJdbcConnectionCreationTest {
    protected QueryRunner createQueryRunner() throws Exception {
        String connectionUrl = TestingH2JdbcModule.createH2ConnectionUrl();
        DriverConnectionFactory delegate = new DriverConnectionFactory((java.sql.Driver)new Driver(), connectionUrl, new Properties(), (CredentialProvider)new EmptyCredentialProvider());
        this.connectionFactory = new BaseJdbcConnectionCreationTest.ConnectionCountingConnectionFactory(delegate);
        return H2QueryRunner.createH2QueryRunner(ImmutableList.of((Object)TpchTable.NATION, (Object)TpchTable.REGION), (Map<String, String>)ImmutableMap.of((Object)"connection-url", (Object)connectionUrl), (Map<String, String>)ImmutableMap.of((Object)"node-scheduler.include-coordinator", (Object)"false"), new TestingConnectionH2Module(this.connectionFactory));
    }

    @Test(dataProvider="testCases")
    public void testJdbcConnectionCreations(@Language(value="SQL") String query, int expectedJdbcConnectionsCount, Optional<String> errorMessage) {
        this.assertJdbcConnections(query, expectedJdbcConnectionsCount, errorMessage);
    }

    @DataProvider
    public Object[][] testCases() {
        return new Object[][]{{"SELECT * FROM nation LIMIT 1", 2, Optional.empty()}, {"SELECT * FROM nation ORDER BY nationkey LIMIT 1", 2, Optional.empty()}, {"SELECT * FROM nation WHERE nationkey = 1", 2, Optional.empty()}, {"SELECT avg(nationkey) FROM nation", 2, Optional.empty()}, {"SELECT * FROM nation, region", 3, Optional.empty()}, {"SELECT * FROM nation n, region r WHERE n.regionkey = r.regionkey", 3, Optional.empty()}, {"SELECT * FROM nation JOIN region USING(regionkey)", 3, Optional.empty()}, {"SELECT * FROM information_schema.schemata", 1, Optional.empty()}, {"SELECT * FROM information_schema.tables", 1, Optional.empty()}, {"SELECT * FROM information_schema.columns", 1, Optional.empty()}, {"SELECT * FROM nation", 2, Optional.empty()}, {"CREATE TABLE copy_of_nation AS SELECT * FROM nation", 6, Optional.empty()}, {"INSERT INTO copy_of_nation SELECT * FROM nation", 6, Optional.empty()}, {"DELETE FROM copy_of_nation WHERE nationkey = 3", 1, Optional.empty()}, {"UPDATE copy_of_nation SET name = 'POLAND' WHERE nationkey = 1", 1, Optional.of("This connector does not support modifying table rows")}, {"MERGE INTO copy_of_nation n USING region r ON r.regionkey= n.regionkey WHEN MATCHED THEN DELETE", 1, Optional.of("This connector does not support modifying table rows")}, {"DROP TABLE copy_of_nation", 1, Optional.empty()}, {"SHOW SCHEMAS", 1, Optional.empty()}, {"SHOW TABLES", 1, Optional.empty()}, {"SHOW STATS FOR nation", 1, Optional.empty()}};
    }

    private static class TestingConnectionH2Module
    implements Module {
        private final BaseJdbcConnectionCreationTest.ConnectionCountingConnectionFactory connectionCountingConnectionFactory;

        TestingConnectionH2Module(BaseJdbcConnectionCreationTest.ConnectionCountingConnectionFactory connectionCountingConnectionFactory) {
            this.connectionCountingConnectionFactory = Objects.requireNonNull(connectionCountingConnectionFactory, "connectionCountingConnectionFactory is null");
        }

        public void configure(Binder binder) {
        }

        @Provides
        @Singleton
        @ForBaseJdbc
        public static JdbcClient provideJdbcClient(BaseJdbcConfig config, ConnectionFactory connectionFactory, IdentifierMapping identifierMapping) {
            return new TestingH2JdbcClient(config, connectionFactory, identifierMapping);
        }

        @Provides
        @Singleton
        @ForBaseJdbc
        public ConnectionFactory getConnectionFactory() {
            return this.connectionCountingConnectionFactory;
        }
    }
}

