/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.MoreFutures;
import io.trino.plugin.jdbc.DynamicFilteringStats;
import io.trino.plugin.jdbc.JdbcDynamicFilteringConfig;
import io.trino.plugin.jdbc.JdbcDynamicFilteringSessionProperties;
import io.trino.plugin.jdbc.JdbcDynamicFilteringSplitManager;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingSplitManager;
import io.trino.testing.TestingTransactionHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJdbcDynamicFilteringSplitManager {
    private static final ConnectorTransactionHandle TRANSACTION_HANDLE = TestingTransactionHandle.create();
    private static final ConnectorSession SESSION = TestingConnectorSession.builder().setPropertyMetadata(new JdbcDynamicFilteringSessionProperties(new JdbcDynamicFilteringConfig()).getSessionProperties()).setPropertyValues((Map)ImmutableMap.of((Object)"dynamic_filtering_wait_timeout", (Object)"3s", (Object)"dynamic_filtering_enabled", (Object)true)).build();
    private static final JdbcTableHandle TABLE_HANDLE = new JdbcTableHandle(new SchemaTableName("schema", "table"), new RemoteTableName(Optional.empty(), Optional.empty(), "table"), Optional.empty());
    private static final DynamicFilter BLOCKED_DYNAMIC_FILTER = new DynamicFilter(){

        public Set<ColumnHandle> getColumnsCovered() {
            return ImmutableSet.of();
        }

        public CompletableFuture<?> isBlocked() {
            return MoreFutures.unmodifiableFuture(new CompletableFuture());
        }

        public boolean isComplete() {
            return false;
        }

        public boolean isAwaitable() {
            return true;
        }

        public TupleDomain<ColumnHandle> getCurrentPredicate() {
            return TupleDomain.all();
        }
    };

    @Test
    public void testBlockingTimeout() throws Exception {
        JdbcDynamicFilteringSplitManager manager = new JdbcDynamicFilteringSplitManager((ConnectorSplitManager)new TestingSplitManager((List)ImmutableList.of()), new DynamicFilteringStats());
        ConnectorSplitSource splitSource = manager.getSplits(TRANSACTION_HANDLE, SESSION, (ConnectorTableHandle)TABLE_HANDLE, BLOCKED_DYNAMIC_FILTER, Constraint.alwaysTrue());
        CompletableFuture future = splitSource.getNextBatch(100);
        Assert.assertFalse((boolean)future.isDone());
        future.get(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)splitSource.isFinished());
        splitSource.close();
    }
}

