/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.jdbc.H2QueryRunner;
import io.trino.plugin.jdbc.TestingH2JdbcModule;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.sql.JdbcSqlExecutor;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestJdbcFlushMetadataCacheProcedure
extends AbstractTestQueryFramework {
    private JdbcSqlExecutor h2SqlExecutor;

    protected QueryRunner createQueryRunner() throws Exception {
        ImmutableMap properties = ImmutableMap.builder().putAll(TestingH2JdbcModule.createProperties()).put((Object)"metadata.cache-ttl", (Object)"10m").put((Object)"metadata.cache-missing", (Object)"true").put((Object)"case-insensitive-name-matching", (Object)"true").buildOrThrow();
        this.h2SqlExecutor = new JdbcSqlExecutor((String)properties.get("connection-url"), new Properties());
        return H2QueryRunner.createH2QueryRunner(List.of(TpchTable.NATION), (Map<String, String>)properties);
    }

    @Test
    public void testFlushMetadataCacheProcedureFlushMetadata() {
        this.h2SqlExecutor.execute("CREATE SCHEMA cached");
        this.assertUpdate("CREATE TABLE cached.cached AS SELECT * FROM tpch.nation", 25L);
        this.assertQuerySucceeds("SELECT name, regionkey FROM cached.cached");
        this.h2SqlExecutor.execute("ALTER TABLE cached.cached ALTER COLUMN regionkey RENAME TO renamed");
        String renamedColumnQuery = "SELECT name, renamed FROM cached.cached";
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(renamedColumnQuery)).hasMessageMatching(".*Column 'renamed' cannot be resolved");
        this.getQueryRunner().execute("CALL system.flush_metadata_cache()");
        this.assertQuerySucceeds(renamedColumnQuery);
        String showTablesSql = "SHOW TABLES FROM cached";
        this.assertQuery(showTablesSql, "VALUES ('cached')");
        this.h2SqlExecutor.execute("ALTER TABLE cached.cached RENAME TO cached.renamed");
        this.assertQuery(showTablesSql, "VALUES ('cached')");
        this.getQueryRunner().execute("CALL system.flush_metadata_cache()");
        this.assertQuery(showTablesSql, "VALUES ('renamed')");
        String showSchemasSql = "SHOW SCHEMAS from jdbc";
        this.assertQuery(showSchemasSql, "VALUES ('cached'), ('information_schema'), ('public'), ('tpch')");
        this.h2SqlExecutor.execute("ALTER SCHEMA cached RENAME TO renamed");
        this.assertQuery(showSchemasSql, "VALUES ('cached'), ('information_schema'), ('public'), ('tpch')");
        this.getQueryRunner().execute("CALL system.flush_metadata_cache()");
        this.assertQuery(showSchemasSql, "VALUES ('information_schema'), ('renamed'), ('public'), ('tpch')");
    }

    @Test
    public void testFlushMetadataCacheProcedureFlushIdentifierMapping() {
        this.assertUpdate("CREATE TABLE cached_name AS SELECT * FROM nation", 25L);
        String query = "SELECT name, regionkey FROM cached_name";
        this.assertQuerySucceeds(query);
        Assertions.assertThatThrownBy(() -> this.h2SqlExecutor.execute("SELECT * FROM tpch.\"cached_name\"")).hasRootCauseMessage("Table \"cached_name\" not found (candidates are: \"CACHED_NAME\"); SQL statement:\nSELECT * FROM tpch.\"cached_name\" [42103-214]");
        this.h2SqlExecutor.execute("SELECT * FROM tpch.\"CACHED_NAME\"");
        this.h2SqlExecutor.execute("ALTER TABLE tpch.\"CACHED_NAME\" RENAME TO tpch.\"cached_name\"");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(query)).hasMessageMatching("(?s)Table \"CACHED_NAME\" not found.*");
        this.getQueryRunner().execute(this.getSession(), "CALL system.flush_metadata_cache()");
        this.assertQuerySucceeds(query);
    }
}

