/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.trino.plugin.jdbc.JdbcSplit;
import java.util.Collection;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJdbcSplit {
    private final JdbcSplit split = new JdbcSplit(Optional.of("additional predicate"));

    @Test
    public void testAddresses() {
        Assert.assertEquals((Collection)this.split.getAddresses(), (Collection)ImmutableList.of());
        Assert.assertEquals((boolean)this.split.isRemotelyAccessible(), (boolean)true);
        JdbcSplit jdbcSplit = new JdbcSplit(Optional.empty());
        Assert.assertEquals((Collection)jdbcSplit.getAddresses(), (Collection)ImmutableList.of());
    }

    @Test
    public void testJsonRoundTrip() {
        JsonCodec codec = JsonCodec.jsonCodec(JdbcSplit.class);
        String json = codec.toJson((Object)this.split);
        JdbcSplit copy = (JdbcSplit)codec.fromJson(json);
        Assert.assertEquals((Object)copy.getAdditionalPredicate(), (Object)this.split.getAdditionalPredicate());
        Assert.assertEquals((Collection)copy.getAddresses(), (Collection)ImmutableList.of());
        Assert.assertEquals((boolean)copy.isRemotelyAccessible(), (boolean)true);
    }
}

