/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.TestingH2JdbcClient;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.plugin.jdbc.ptf.Query;
import io.trino.spi.ptf.ConnectorTableFunction;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.h2.Driver;

public class TestingH2JdbcModule
implements Module {
    private final TestingH2JdbcClientFactory testingH2JdbcClientFactory;

    public TestingH2JdbcModule() {
        this((config, connectionFactory, identifierMapping) -> new TestingH2JdbcClient(config, connectionFactory, identifierMapping));
    }

    public TestingH2JdbcModule(TestingH2JdbcClientFactory testingH2JdbcClientFactory) {
        this.testingH2JdbcClientFactory = Objects.requireNonNull(testingH2JdbcClientFactory, "testingH2JdbcClientFactory is null");
    }

    public void configure(Binder binder) {
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public JdbcClient provideJdbcClient(BaseJdbcConfig config, ConnectionFactory connectionFactory, IdentifierMapping identifierMapping) {
        return this.testingH2JdbcClientFactory.create(config, connectionFactory, identifierMapping);
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public ConnectionFactory getConnectionFactory(BaseJdbcConfig config, CredentialProvider credentialProvider) {
        return new DriverConnectionFactory((java.sql.Driver)new Driver(), config, credentialProvider);
    }

    public static Map<String, String> createProperties() {
        return ImmutableMap.of((Object)"connection-url", (Object)TestingH2JdbcModule.createH2ConnectionUrl());
    }

    public static String createH2ConnectionUrl() {
        return String.format("jdbc:h2:mem:test%s;DB_CLOSE_DELAY=-1", System.nanoTime() + ThreadLocalRandom.current().nextLong());
    }

    public static interface TestingH2JdbcClientFactory {
        public TestingH2JdbcClient create(BaseJdbcConfig var1, ConnectionFactory var2, IdentifierMapping var3);
    }
}

