/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.jdbc.expression.CallPattern;
import io.trino.plugin.jdbc.expression.ExpressionCapture;
import io.trino.plugin.jdbc.expression.ExpressionMappingParser;
import io.trino.plugin.jdbc.expression.ExpressionPattern;
import io.trino.plugin.jdbc.expression.LongTypeParameter;
import io.trino.plugin.jdbc.expression.SimpleTypePattern;
import io.trino.plugin.jdbc.expression.TypeClassPattern;
import io.trino.plugin.jdbc.expression.TypeParameterCapture;
import io.trino.plugin.jdbc.expression.TypeParameterPattern;
import io.trino.plugin.jdbc.expression.TypePattern;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestExpressionMappingParser {
    private static final Map<String, Set<String>> TYPE_CLASSES = Map.of("integer_class", Set.of("integer", "bigint"));

    @Test
    public void testCapture() {
        TestExpressionMappingParser.assertExpressionPattern("b", (ExpressionPattern)new ExpressionCapture("b"));
        TestExpressionMappingParser.assertExpressionPattern("b: bigint", (ExpressionPattern)new ExpressionCapture("b", (TypePattern)TestExpressionMappingParser.type("bigint")));
        TestExpressionMappingParser.assertExpressionPattern("bar: varchar(n)", (ExpressionPattern)new ExpressionCapture("bar", (TypePattern)TestExpressionMappingParser.type("varchar", TestExpressionMappingParser.parameter("n"))));
    }

    @Test
    public void testParameterizedType() {
        TestExpressionMappingParser.assertExpressionPattern("bar: varchar(3)", (ExpressionPattern)new ExpressionCapture("bar", (TypePattern)TestExpressionMappingParser.type("varchar", TestExpressionMappingParser.parameter(3L))));
    }

    @Test
    public void testCallPattern() {
        TestExpressionMappingParser.assertExpressionPattern("is_null(a)", (ExpressionPattern)new CallPattern("is_null", List.of(new ExpressionCapture("a")), Optional.empty()));
        TestExpressionMappingParser.assertExpressionPattern("$like(a: varchar(n), b: varchar(m))", (ExpressionPattern)new CallPattern("$like", List.of(new ExpressionCapture("a", (TypePattern)TestExpressionMappingParser.type("varchar", TestExpressionMappingParser.parameter("n"))), new ExpressionCapture("b", (TypePattern)TestExpressionMappingParser.type("varchar", TestExpressionMappingParser.parameter("m")))), Optional.empty()));
        TestExpressionMappingParser.assertExpressionPattern("$like(a: varchar(n), b: varchar(m)): boolean", (ExpressionPattern)new CallPattern("$like", List.of(new ExpressionCapture("a", (TypePattern)TestExpressionMappingParser.type("varchar", TestExpressionMappingParser.parameter("n"))), new ExpressionCapture("b", (TypePattern)TestExpressionMappingParser.type("varchar", TestExpressionMappingParser.parameter("m")))), Optional.of(TestExpressionMappingParser.type("boolean"))));
    }

    @Test
    public void testCallPatternWithTypeClass() {
        TypeClassPattern integerClass = TestExpressionMappingParser.typeClass("integer_class", Set.of("integer", "bigint"));
        TestExpressionMappingParser.assertExpressionPattern("add(a: integer_class, b: integer_class): integer_class", (ExpressionPattern)new CallPattern("add", List.of(new ExpressionCapture("a", (TypePattern)integerClass), new ExpressionCapture("b", (TypePattern)integerClass)), Optional.of(integerClass)));
    }

    private static void assertExpressionPattern(String expressionPattern, ExpressionPattern expected) {
        TestExpressionMappingParser.assertExpressionPattern(expressionPattern, expressionPattern, expected);
    }

    private static void assertExpressionPattern(String expressionPattern, String canonical, ExpressionPattern expected) {
        Assert.assertEquals((Object)TestExpressionMappingParser.expressionPattern(expressionPattern), (Object)expected);
        Assert.assertEquals((String)expected.toString(), (String)canonical);
    }

    private static ExpressionPattern expressionPattern(String expressionPattern) {
        return new ExpressionMappingParser(TYPE_CLASSES).createExpressionPattern(expressionPattern);
    }

    private static SimpleTypePattern type(String baseName) {
        return new SimpleTypePattern(baseName, (List)ImmutableList.of());
    }

    private static SimpleTypePattern type(String baseName, TypeParameterPattern ... parameter) {
        return new SimpleTypePattern(baseName, (List)ImmutableList.copyOf((Object[])parameter));
    }

    private static TypeParameterPattern parameter(long value) {
        return new LongTypeParameter(value);
    }

    private static TypeParameterPattern parameter(String name) {
        return new TypeParameterCapture(name);
    }

    private static TypeClassPattern typeClass(String typeClassName, Set<String> typeNames) {
        return new TypeClassPattern(typeClassName, typeNames);
    }
}

