/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.collect.MoreCollectors;
import io.trino.matching.Match;
import io.trino.plugin.jdbc.expression.ExpressionMappingParser;
import io.trino.plugin.jdbc.expression.ExpressionPattern;
import io.trino.plugin.jdbc.expression.MatchContext;
import io.trino.plugin.jdbc.expression.TypePattern;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestExpressionMatching {
    private static final Map<String, Set<String>> TYPE_CLASSES = Map.of("integer_class", Set.of("tinyint", "smallint", "integer", "bigint"));

    @Test
    public void testMatchType() {
        DecimalType type = DecimalType.createDecimalType((int)10, (int)2);
        TypePattern pattern = TestExpressionMatching.typePattern("decimal(p, s)");
        Match match = (Match)pattern.getPattern().match((Object)type).collect(MoreCollectors.onlyElement());
        MatchContext matchContext = new MatchContext();
        pattern.resolve(match.captures(), matchContext);
        Assertions.assertThat((Collection)matchContext.keys()).containsExactlyInAnyOrder((Object[])new String[]{"p", "s"});
        Assertions.assertThat((Object)matchContext.get("p")).isEqualTo((Object)10L);
        Assertions.assertThat((Object)matchContext.get("s")).isEqualTo((Object)2L);
    }

    @Test
    public void testExpressionCapture() {
        Call expression = new Call((Type)DecimalType.createDecimalType((int)21, (int)2), new FunctionName("add"), List.of(new Variable("first", (Type)DecimalType.createDecimalType((int)10, (int)2)), new Variable("second", (Type)BigintType.BIGINT)));
        ExpressionPattern pattern = TestExpressionMatching.expressionPattern("foo: decimal(p, s)");
        Match match = (Match)pattern.getPattern().match((Object)expression).collect(MoreCollectors.onlyElement());
        MatchContext matchContext = new MatchContext();
        pattern.resolve(match.captures(), matchContext);
        Assertions.assertThat((Collection)matchContext.keys()).containsExactlyInAnyOrder((Object[])new String[]{"p", "s", "foo"});
        Assertions.assertThat((Object)matchContext.get("p")).isEqualTo((Object)21L);
        Assertions.assertThat((Object)matchContext.get("s")).isEqualTo((Object)2L);
        Assertions.assertThat((Object)matchContext.get("foo")).isSameAs((Object)expression);
    }

    @Test
    public void testMatchCall() {
        Call expression = new Call((Type)DecimalType.createDecimalType((int)21, (int)2), new FunctionName("add"), List.of(new Variable("first", (Type)DecimalType.createDecimalType((int)10, (int)2)), new Variable("second", (Type)BigintType.BIGINT)));
        ExpressionPattern pattern = TestExpressionMatching.expressionPattern("add(foo: decimal(p, s), bar: bigint)");
        Match match = (Match)pattern.getPattern().match((Object)expression).collect(MoreCollectors.onlyElement());
        MatchContext matchContext = new MatchContext();
        pattern.resolve(match.captures(), matchContext);
        Assertions.assertThat((Collection)matchContext.keys()).containsExactlyInAnyOrder((Object[])new String[]{"p", "s", "foo", "bar"});
        Assertions.assertThat((Object)matchContext.get("p")).isEqualTo((Object)10L);
        Assertions.assertThat((Object)matchContext.get("s")).isEqualTo((Object)2L);
        Assertions.assertThat((Object)matchContext.get("foo")).isEqualTo((Object)new Variable("first", (Type)DecimalType.createDecimalType((int)10, (int)2)));
        Assertions.assertThat((Object)matchContext.get("bar")).isEqualTo((Object)new Variable("second", (Type)BigintType.BIGINT));
    }

    @Test
    public void testMatchCallWithTypeClass() {
        Call expression = new Call((Type)BigintType.BIGINT, new FunctionName("add"), List.of(new Variable("first", (Type)IntegerType.INTEGER), new Variable("second", (Type)BigintType.BIGINT)));
        ExpressionPattern pattern = TestExpressionMatching.expressionPattern("add(foo: integer_class, bar: integer_class): integer_class");
        Match match = (Match)pattern.getPattern().match((Object)expression).collect(MoreCollectors.onlyElement());
        MatchContext matchContext = new MatchContext();
        pattern.resolve(match.captures(), matchContext);
        Assertions.assertThat((Collection)matchContext.keys()).containsExactlyInAnyOrder((Object[])new String[]{"foo", "bar"});
        Assertions.assertThat((Object)matchContext.get("foo")).isEqualTo((Object)new Variable("first", (Type)IntegerType.INTEGER));
        Assertions.assertThat((Object)matchContext.get("bar")).isEqualTo((Object)new Variable("second", (Type)BigintType.BIGINT));
    }

    private static ExpressionPattern expressionPattern(String expressionPattern) {
        return new ExpressionMappingParser(TYPE_CLASSES).createExpressionPattern(expressionPattern);
    }

    private static TypePattern typePattern(String typePattern) {
        return new ExpressionMappingParser(TYPE_CLASSES).createTypePattern(typePattern);
    }
}

