/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.mapping;

import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.trino.plugin.jdbc.mapping.IdentifierMappingRules;
import io.trino.plugin.jdbc.mapping.SchemaMappingRule;
import io.trino.plugin.jdbc.mapping.TableMappingRule;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.testng.annotations.Test;

public class TestIdentifierMappingRules {
    @Test
    public void testParsing() {
        String json = "{\n  \"schemas\" : [ {\n    \"remoteSchema\" : \"remote_schema\",\n    \"mapping\" : \"trino_schema\"\n  } ],\n  \"tables\" : [ {\n    \"remoteSchema\" : \"remote_schema\",\n    \"remoteTable\" : \"remote_table\",\n    \"mapping\" : \"trino_table\"\n  } ]\n}";
        JsonCodec identifierMappingRulesJsonCodec = JsonCodec.jsonCodec(IdentifierMappingRules.class);
        ((ObjectAssert)Assertions.assertThat((Object)((IdentifierMappingRules)identifierMappingRulesJsonCodec.fromJson(json))).isEqualTo((Object)new IdentifierMappingRules((List)ImmutableList.of((Object)new SchemaMappingRule("remote_schema", "trino_schema")), (List)ImmutableList.of((Object)new TableMappingRule("remote_schema", "remote_table", "trino_table"))))).isNotEqualTo((Object)new IdentifierMappingRules((List)ImmutableList.of(), (List)ImmutableList.of()));
    }
}

