/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcPageSink;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;
import javax.inject.Inject;

public class JdbcPageSinkProvider
implements ConnectorPageSinkProvider {
    private final JdbcClient jdbcClient;
    private final RemoteQueryModifier queryModifier;

    @Inject
    public JdbcPageSinkProvider(JdbcClient jdbcClient, RemoteQueryModifier remoteQueryModifier) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient, "jdbcClient is null");
        this.queryModifier = Objects.requireNonNull(remoteQueryModifier, "remoteQueryModifier is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle tableHandle, ConnectorPageSinkId pageSinkId) {
        return new JdbcPageSink(session, (JdbcOutputTableHandle)tableHandle, this.jdbcClient, pageSinkId, this.queryModifier);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle tableHandle, ConnectorPageSinkId pageSinkId) {
        return new JdbcPageSink(session, (JdbcOutputTableHandle)tableHandle, this.jdbcClient, pageSinkId, this.queryModifier);
    }
}

