/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.mapping;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import io.trino.plugin.jdbc.mapping.IdentifierMapping;
import io.trino.plugin.jdbc.mapping.IdentifierMappingRules;
import io.trino.plugin.jdbc.mapping.SchemaMappingRule;
import io.trino.plugin.jdbc.mapping.TableMappingRule;
import io.trino.spi.security.ConnectorIdentity;
import java.sql.Connection;
import java.util.Map;
import java.util.Objects;

public class RuleBasedIdentifierMapping
implements IdentifierMapping {
    private final Map<String, String> fromRemoteSchema;
    private final Map<String, String> toRemoteSchema;
    private final Table<String, String, String> fromRemoteTable;
    private final Table<String, String, String> toRemoteTable;
    private final IdentifierMapping delegate;

    public RuleBasedIdentifierMapping(IdentifierMappingRules rules, IdentifierMapping delegate) {
        Objects.requireNonNull(rules, "rules is null");
        Objects.requireNonNull(delegate, "defaultIdentifierMapping is null");
        this.fromRemoteSchema = (Map)rules.getSchemaMapping().stream().collect(ImmutableMap.toImmutableMap(SchemaMappingRule::getRemoteSchema, SchemaMappingRule::getMapping));
        this.toRemoteSchema = (Map)rules.getSchemaMapping().stream().collect(ImmutableMap.toImmutableMap(SchemaMappingRule::getMapping, SchemaMappingRule::getRemoteSchema));
        this.fromRemoteTable = (Table)rules.getTableMapping().stream().collect(ImmutableTable.toImmutableTable(TableMappingRule::getRemoteSchema, TableMappingRule::getRemoteTable, TableMappingRule::getMapping));
        this.toRemoteTable = (Table)rules.getTableMapping().stream().collect(ImmutableTable.toImmutableTable(TableMappingRule::getRemoteSchema, TableMappingRule::getMapping, TableMappingRule::getRemoteTable));
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public String fromRemoteSchemaName(String remoteSchemaName) {
        String schemaName = this.fromRemoteSchema.get(remoteSchemaName);
        if (schemaName == null) {
            schemaName = this.delegate.fromRemoteSchemaName(remoteSchemaName);
        }
        return schemaName;
    }

    @Override
    public String fromRemoteTableName(String remoteSchemaName, String remoteTableName) {
        String tableName = (String)this.fromRemoteTable.get((Object)remoteSchemaName, (Object)remoteTableName);
        if (tableName == null) {
            tableName = this.delegate.fromRemoteTableName(remoteSchemaName, remoteTableName);
        }
        return tableName;
    }

    @Override
    public String fromRemoteColumnName(String remoteColumnName) {
        return this.delegate.fromRemoteColumnName(remoteColumnName);
    }

    @Override
    public String toRemoteSchemaName(ConnectorIdentity identity, Connection connection, String schemaName) {
        String remoteSchemaName = this.toRemoteSchema.get(schemaName);
        if (remoteSchemaName == null) {
            remoteSchemaName = this.delegate.toRemoteSchemaName(identity, connection, schemaName);
        }
        return remoteSchemaName;
    }

    @Override
    public String toRemoteTableName(ConnectorIdentity identity, Connection connection, String remoteSchema, String tableName) {
        String remoteTableName = (String)this.toRemoteTable.get((Object)remoteSchema, (Object)tableName);
        if (remoteTableName == null) {
            remoteTableName = this.delegate.toRemoteTableName(identity, connection, remoteSchema, tableName);
        }
        return remoteTableName;
    }

    @Override
    public String toRemoteColumnName(Connection connection, String columnName) {
        return this.delegate.toRemoteColumnName(connection, columnName);
    }
}

