/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Inject;
import io.airlift.jmx.CacheStatsMBean;
import io.airlift.units.Duration;
import io.trino.cache.CacheUtils;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.IdentityCacheMapping;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcProcedureHandle;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.StatsCollecting;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.Type;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class CachingJdbcClient
implements JdbcClient {
    private static final Object NULL_MARKER = new Object();
    private final JdbcClient delegate;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final boolean cacheMissing;
    private final IdentityCacheMapping identityMapping;
    private final Cache<IdentityCacheMapping.IdentityCacheKey, Set<String>> schemaNamesCache;
    private final Cache<TableNamesCacheKey, List<SchemaTableName>> tableNamesCache;
    private final Cache<TableHandlesByNameCacheKey, Optional<JdbcTableHandle>> tableHandlesByNameCache;
    private final Cache<TableHandlesByQueryCacheKey, JdbcTableHandle> tableHandlesByQueryCache;
    private final Cache<ProcedureHandlesByQueryCacheKey, JdbcProcedureHandle> procedureHandlesByQueryCache;
    private final Cache<ColumnsCacheKey, List<JdbcColumnHandle>> columnsCache;
    private final Cache<JdbcTableHandle, TableStatistics> statisticsCache;

    @Inject
    public CachingJdbcClient(@StatsCollecting JdbcClient delegate, Set<SessionPropertiesProvider> sessionPropertiesProviders, IdentityCacheMapping identityMapping, BaseJdbcConfig config) {
        this(Ticker.systemTicker(), delegate, sessionPropertiesProviders, identityMapping, config.getMetadataCacheTtl(), config.getSchemaNamesCacheTtl(), config.getTableNamesCacheTtl(), config.getStatisticsCacheTtl(), config.isCacheMissing(), config.getCacheMaximumSize());
    }

    public CachingJdbcClient(Ticker ticker, JdbcClient delegate, Set<SessionPropertiesProvider> sessionPropertiesProviders, IdentityCacheMapping identityMapping, Duration metadataCachingTtl, Duration schemaNamesCachingTtl, Duration tableNamesCachingTtl, Duration statisticsCachingTtl, boolean cacheMissing, long cacheMaximumSize) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.sessionProperties = (List)sessionPropertiesProviders.stream().flatMap(provider -> provider.getSessionProperties().stream()).collect(ImmutableList.toImmutableList());
        this.cacheMissing = cacheMissing;
        this.identityMapping = Objects.requireNonNull(identityMapping, "identityMapping is null");
        this.schemaNamesCache = CachingJdbcClient.buildCache(ticker, cacheMaximumSize, schemaNamesCachingTtl);
        this.tableNamesCache = CachingJdbcClient.buildCache(ticker, cacheMaximumSize, tableNamesCachingTtl);
        this.tableHandlesByNameCache = CachingJdbcClient.buildCache(ticker, cacheMaximumSize, metadataCachingTtl);
        this.tableHandlesByQueryCache = CachingJdbcClient.buildCache(ticker, cacheMaximumSize, metadataCachingTtl);
        this.procedureHandlesByQueryCache = CachingJdbcClient.buildCache(ticker, cacheMaximumSize, metadataCachingTtl);
        this.columnsCache = CachingJdbcClient.buildCache(ticker, cacheMaximumSize, metadataCachingTtl);
        this.statisticsCache = CachingJdbcClient.buildCache(ticker, cacheMaximumSize, statisticsCachingTtl);
    }

    private static <K, V> Cache<K, V> buildCache(Ticker ticker, long cacheSize, Duration cachingTtl) {
        return EvictableCacheBuilder.newBuilder().ticker(ticker).maximumSize(cacheSize).expireAfterWrite(cachingTtl.toMillis(), TimeUnit.MILLISECONDS).shareNothingWhenDisabled().recordStats().build();
    }

    @Override
    public boolean schemaExists(ConnectorSession session, String schema) {
        return this.getSchemaNames(session).contains(schema);
    }

    @Override
    public Set<String> getSchemaNames(ConnectorSession session) {
        IdentityCacheMapping.IdentityCacheKey key = this.getIdentityKey(session);
        return CachingJdbcClient.get(this.schemaNamesCache, key, () -> this.delegate.getSchemaNames(session));
    }

    @Override
    public List<SchemaTableName> getTableNames(ConnectorSession session, Optional<String> schema) {
        TableNamesCacheKey key = new TableNamesCacheKey(this.getIdentityKey(session), schema);
        return CachingJdbcClient.get(this.tableNamesCache, key, () -> this.delegate.getTableNames(session, schema));
    }

    @Override
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        if (tableHandle.getColumns().isPresent()) {
            return tableHandle.getColumns().get();
        }
        ColumnsCacheKey key = new ColumnsCacheKey(this.getIdentityKey(session), this.getSessionProperties(session), tableHandle.getRequiredNamedRelation().getSchemaTableName());
        return CachingJdbcClient.get(this.columnsCache, key, () -> this.delegate.getColumns(session, tableHandle));
    }

    @Override
    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        return this.delegate.toColumnMapping(session, connection, typeHandle);
    }

    @Override
    public List<ColumnMapping> toColumnMappings(ConnectorSession session, List<JdbcTypeHandle> typeHandles) {
        return this.delegate.toColumnMappings(session, typeHandles);
    }

    @Override
    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        return this.delegate.toWriteMapping(session, type);
    }

    @Override
    public Optional<Type> getSupportedType(ConnectorSession session, Type type) {
        return this.delegate.getSupportedType(session, type);
    }

    @Override
    public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return this.delegate.supportsAggregationPushdown(session, table, aggregates, assignments, groupingSets);
    }

    @Override
    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.delegate.implementAggregation(session, aggregate, assignments);
    }

    @Override
    public Optional<ParameterizedExpression> convertPredicate(ConnectorSession session, ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        return this.delegate.convertPredicate(session, expression, assignments);
    }

    @Override
    public ConnectorSplitSource getSplits(ConnectorSession session, JdbcTableHandle tableHandle) {
        return this.delegate.getSplits(session, tableHandle);
    }

    @Override
    public ConnectorSplitSource getSplits(ConnectorSession session, JdbcProcedureHandle procedureHandle) {
        return this.delegate.getSplits(session, procedureHandle);
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcSplit split, JdbcTableHandle tableHandle) throws SQLException {
        return this.delegate.getConnection(session, split, tableHandle);
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcSplit split, JdbcProcedureHandle procedureHandle) throws SQLException {
        return this.delegate.getConnection(session, split, procedureHandle);
    }

    @Override
    public void abortReadConnection(Connection connection, ResultSet resultSet) throws SQLException {
        this.delegate.abortReadConnection(connection, resultSet);
    }

    @Override
    public PreparedQuery prepareQuery(ConnectorSession session, JdbcTableHandle table, Optional<List<List<JdbcColumnHandle>>> groupingSets, List<JdbcColumnHandle> columns, Map<String, ParameterizedExpression> columnExpressions) {
        return this.delegate.prepareQuery(session, table, groupingSets, columns, columnExpressions);
    }

    @Override
    public PreparedStatement buildSql(ConnectorSession session, Connection connection, JdbcSplit split, JdbcTableHandle table, List<JdbcColumnHandle> columns) throws SQLException {
        return this.delegate.buildSql(session, connection, split, table, columns);
    }

    @Override
    public CallableStatement buildProcedure(ConnectorSession session, Connection connection, JdbcSplit split, JdbcProcedureHandle procedureHandle) throws SQLException {
        return this.delegate.buildProcedure(session, connection, split, procedureHandle);
    }

    @Override
    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, Map<JdbcColumnHandle, String> leftProjections, PreparedQuery rightSource, Map<JdbcColumnHandle, String> rightProjections, List<ParameterizedExpression> joinConditions, JoinStatistics statistics) {
        return this.delegate.implementJoin(session, joinType, leftSource, leftProjections, rightSource, rightProjections, joinConditions, statistics);
    }

    @Override
    public Optional<PreparedQuery> legacyImplementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        return this.delegate.legacyImplementJoin(session, joinType, leftSource, rightSource, joinConditions, rightAssignments, leftAssignments, statistics);
    }

    @Override
    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        return this.delegate.supportsTopN(session, handle, sortOrder);
    }

    @Override
    public boolean isTopNGuaranteed(ConnectorSession session) {
        return this.delegate.isTopNGuaranteed(session);
    }

    @Override
    public boolean supportsLimit() {
        return this.delegate.supportsLimit();
    }

    @Override
    public boolean isLimitGuaranteed(ConnectorSession session) {
        return this.delegate.isLimitGuaranteed(session);
    }

    @Override
    public Optional<JdbcTableHandle> getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        TableHandlesByNameCacheKey key = new TableHandlesByNameCacheKey(this.getIdentityKey(session), schemaTableName);
        Optional cachedTableHandle = (Optional)this.tableHandlesByNameCache.getIfPresent((Object)key);
        if (cachedTableHandle != null) {
            if (this.cacheMissing || cachedTableHandle.isPresent()) {
                return cachedTableHandle;
            }
            this.tableHandlesByNameCache.invalidate((Object)key);
        }
        return CachingJdbcClient.get(this.tableHandlesByNameCache, key, () -> this.delegate.getTableHandle(session, schemaTableName));
    }

    @Override
    public JdbcTableHandle getTableHandle(ConnectorSession session, PreparedQuery preparedQuery) {
        TableHandlesByQueryCacheKey key = new TableHandlesByQueryCacheKey(this.getIdentityKey(session), preparedQuery);
        return CachingJdbcClient.get(this.tableHandlesByQueryCache, key, () -> this.delegate.getTableHandle(session, preparedQuery));
    }

    @Override
    public JdbcProcedureHandle getProcedureHandle(ConnectorSession session, JdbcProcedureHandle.ProcedureQuery procedureQuery) {
        ProcedureHandlesByQueryCacheKey key = new ProcedureHandlesByQueryCacheKey(this.getIdentityKey(session), procedureQuery);
        return CachingJdbcClient.get(this.procedureHandlesByQueryCache, key, () -> this.delegate.getProcedureHandle(session, procedureQuery));
    }

    @Override
    public void commitCreateTable(ConnectorSession session, JdbcOutputTableHandle handle, Set<Long> pageSinkIds) {
        this.delegate.commitCreateTable(session, handle, pageSinkIds);
        this.invalidateTableCaches(new SchemaTableName(handle.getSchemaName(), handle.getTableName()));
    }

    @Override
    public JdbcOutputTableHandle beginInsertTable(ConnectorSession session, JdbcTableHandle tableHandle, List<JdbcColumnHandle> columns) {
        return this.delegate.beginInsertTable(session, tableHandle, columns);
    }

    @Override
    public void finishInsertTable(ConnectorSession session, JdbcOutputTableHandle handle, Set<Long> pageSinkIds) {
        this.delegate.finishInsertTable(session, handle, pageSinkIds);
        this.onDataChanged(new SchemaTableName(handle.getSchemaName(), handle.getTableName()));
    }

    @Override
    public void dropTable(ConnectorSession session, JdbcTableHandle jdbcTableHandle) {
        this.delegate.dropTable(session, jdbcTableHandle);
        this.invalidateTableCaches(jdbcTableHandle.asPlainTable().getSchemaTableName());
    }

    @Override
    public void rollbackCreateTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        this.delegate.rollbackCreateTable(session, handle);
    }

    @Override
    public boolean supportsRetries() {
        return this.delegate.supportsRetries();
    }

    @Override
    public String buildInsertSql(JdbcOutputTableHandle handle, List<WriteFunction> columnWriters) {
        return this.delegate.buildInsertSql(handle, columnWriters);
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcOutputTableHandle handle) throws SQLException {
        return this.delegate.getConnection(session, handle);
    }

    @Override
    public PreparedStatement getPreparedStatement(Connection connection, String sql, Optional<Integer> columnCount) throws SQLException {
        return this.delegate.getPreparedStatement(connection, sql, columnCount);
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle, TupleDomain<ColumnHandle> tupleDomain) {
        Preconditions.checkArgument((boolean)tupleDomain.isAll(), (String)"Unexpected non-ALL constraint: %s", tupleDomain);
        return this.getTableStatistics(session, handle);
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle) {
        TableStatistics cachedStatistics = (TableStatistics)this.statisticsCache.getIfPresent((Object)handle);
        if (cachedStatistics != null) {
            if (this.cacheMissing || !cachedStatistics.equals((Object)TableStatistics.empty())) {
                return cachedStatistics;
            }
            this.statisticsCache.invalidate((Object)handle);
        }
        return CachingJdbcClient.get(this.statisticsCache, handle, () -> this.delegate.getTableStatistics(session, handle));
    }

    @Override
    public void createSchema(ConnectorSession session, String schemaName) {
        this.delegate.createSchema(session, schemaName);
        this.invalidateSchemasCache();
    }

    @Override
    public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        this.delegate.dropSchema(session, schemaName, cascade);
        this.invalidateSchemasCache();
    }

    @Override
    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        this.delegate.renameSchema(session, schemaName, newSchemaName);
        this.invalidateSchemasCache();
    }

    @Override
    public Optional<String> getTableComment(ResultSet resultSet) throws SQLException {
        return this.delegate.getTableComment(resultSet);
    }

    @Override
    public void setTableComment(ConnectorSession session, JdbcTableHandle handle, Optional<String> comment) {
        this.delegate.setTableComment(session, handle, comment);
        this.invalidateTableCaches(handle.asPlainTable().getSchemaTableName());
    }

    @Override
    public void setColumnComment(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Optional<String> comment) {
        this.delegate.setColumnComment(session, handle, column, comment);
        this.invalidateTableCaches(handle.asPlainTable().getSchemaTableName());
    }

    @Override
    public void addColumn(ConnectorSession session, JdbcTableHandle handle, ColumnMetadata column) {
        this.delegate.addColumn(session, handle, column);
        this.invalidateTableCaches(handle.asPlainTable().getSchemaTableName());
    }

    @Override
    public void dropColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        this.delegate.dropColumn(session, handle, column);
        this.invalidateTableCaches(handle.asPlainTable().getSchemaTableName());
    }

    @Override
    public void renameColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        this.delegate.renameColumn(session, handle, jdbcColumn, newColumnName);
        this.invalidateTableCaches(handle.asPlainTable().getSchemaTableName());
    }

    @Override
    public void setColumnType(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Type type) {
        this.delegate.setColumnType(session, handle, column, type);
        this.invalidateTableCaches(handle.asPlainTable().getSchemaTableName());
    }

    @Override
    public void renameTable(ConnectorSession session, JdbcTableHandle handle, SchemaTableName newTableName) {
        this.delegate.renameTable(session, handle, newTableName);
        this.invalidateTableCaches(handle.asPlainTable().getSchemaTableName());
        this.invalidateTableCaches(newTableName);
    }

    @Override
    public void setTableProperties(ConnectorSession session, JdbcTableHandle handle, Map<String, Optional<Object>> properties) {
        this.delegate.setTableProperties(session, handle, properties);
        this.invalidateTableCaches(handle.asPlainTable().getSchemaTableName());
    }

    @Override
    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        this.delegate.createTable(session, tableMetadata);
        this.invalidateTableCaches(tableMetadata.getTable());
    }

    @Override
    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        return this.delegate.beginCreateTable(session, tableMetadata);
    }

    @Override
    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return this.delegate.getSystemTable(session, tableName);
    }

    @Override
    public String quoted(String name) {
        return this.delegate.quoted(name);
    }

    @Override
    public String quoted(RemoteTableName remoteTableName) {
        return this.delegate.quoted(remoteTableName);
    }

    @Override
    public Map<String, Object> getTableProperties(ConnectorSession session, JdbcTableHandle tableHandle) {
        return this.delegate.getTableProperties(session, tableHandle);
    }

    @Override
    public Optional<TableScanRedirectApplicationResult> getTableScanRedirection(ConnectorSession session, JdbcTableHandle tableHandle) {
        return this.delegate.getTableScanRedirection(session, tableHandle);
    }

    @Override
    public OptionalInt getMaxWriteParallelism(ConnectorSession session) {
        return this.delegate.getMaxWriteParallelism(session);
    }

    @Override
    public OptionalInt getMaxColumnNameLength(ConnectorSession session) {
        return this.delegate.getMaxColumnNameLength(session);
    }

    public void onDataChanged(SchemaTableName table) {
        CacheUtils.invalidateAllIf(this.statisticsCache, key -> key.mayReference(table));
    }

    @Deprecated
    public void onDataChanged(JdbcTableHandle handle) {
        this.statisticsCache.invalidate((Object)handle);
    }

    @Override
    public OptionalLong delete(ConnectorSession session, JdbcTableHandle handle) {
        OptionalLong deletedRowsCount = this.delegate.delete(session, handle);
        this.onDataChanged(handle.getRequiredNamedRelation().getSchemaTableName());
        return deletedRowsCount;
    }

    @Override
    public OptionalLong update(ConnectorSession session, JdbcTableHandle handle) {
        OptionalLong updatedRowsCount = this.delegate.update(session, handle);
        this.onDataChanged(handle.getRequiredNamedRelation().getSchemaTableName());
        return updatedRowsCount;
    }

    @Override
    public void truncateTable(ConnectorSession session, JdbcTableHandle handle) {
        this.delegate.truncateTable(session, handle);
        this.onDataChanged(handle.getRequiredNamedRelation().getSchemaTableName());
    }

    @Managed
    public void flushCache() {
        this.schemaNamesCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.tableHandlesByNameCache.invalidateAll();
        this.tableHandlesByQueryCache.invalidateAll();
        this.columnsCache.invalidateAll();
        this.statisticsCache.invalidateAll();
    }

    private IdentityCacheMapping.IdentityCacheKey getIdentityKey(ConnectorSession session) {
        return this.identityMapping.getRemoteUserCacheKey(session);
    }

    private Map<String, Object> getSessionProperties(ConnectorSession session) {
        return (Map)this.sessionProperties.stream().map(property -> Map.entry(property.getName(), CachingJdbcClient.getSessionProperty(session, property))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Object getSessionProperty(ConnectorSession session, PropertyMetadata<?> property) {
        return MoreObjects.firstNonNull((Object)session.getProperty(property.getName(), property.getJavaType()), (Object)NULL_MARKER);
    }

    private void invalidateSchemasCache() {
        this.schemaNamesCache.invalidateAll();
    }

    private void invalidateTableCaches(SchemaTableName schemaTableName) {
        this.invalidateColumnsCache(schemaTableName);
        CacheUtils.invalidateAllIf(this.tableHandlesByNameCache, key -> key.tableName.equals((Object)schemaTableName));
        this.tableHandlesByQueryCache.invalidateAll();
        CacheUtils.invalidateAllIf(this.tableNamesCache, key -> key.schemaName.equals(Optional.of(schemaTableName.getSchemaName())));
        CacheUtils.invalidateAllIf(this.statisticsCache, key -> key.mayReference(schemaTableName));
    }

    private void invalidateColumnsCache(SchemaTableName table) {
        CacheUtils.invalidateAllIf(this.columnsCache, key -> key.table.equals((Object)table));
    }

    @VisibleForTesting
    CacheStats getSchemaNamesCacheStats() {
        return this.schemaNamesCache.stats();
    }

    @VisibleForTesting
    CacheStats getTableNamesCacheStats() {
        return this.tableNamesCache.stats();
    }

    @VisibleForTesting
    CacheStats getTableHandlesByNameCacheStats() {
        return this.tableHandlesByNameCache.stats();
    }

    @VisibleForTesting
    CacheStats getTableHandlesByQueryCacheStats() {
        return this.tableHandlesByQueryCache.stats();
    }

    @VisibleForTesting
    CacheStats getProcedureHandlesByQueryCacheStats() {
        return this.procedureHandlesByQueryCache.stats();
    }

    @VisibleForTesting
    CacheStats getColumnsCacheStats() {
        return this.columnsCache.stats();
    }

    @VisibleForTesting
    CacheStats getStatisticsCacheStats() {
        return this.statisticsCache.stats();
    }

    private static <K, V> V get(Cache<K, V> cache, K key, Callable<V> loader) {
        try {
            return (V)cache.get(key, loader);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw e;
        }
        catch (ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new UncheckedExecutionException((Throwable)e);
        }
    }

    @Managed
    @Nested
    public CacheStatsMBean getSchemaNamesStats() {
        return new CacheStatsMBean(this.schemaNamesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableNamesCache() {
        return new CacheStatsMBean(this.tableNamesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableHandlesByNameCache() {
        return new CacheStatsMBean(this.tableHandlesByNameCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableHandlesByQueryCache() {
        return new CacheStatsMBean(this.tableHandlesByQueryCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getColumnsCache() {
        return new CacheStatsMBean(this.columnsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getStatisticsCache() {
        return new CacheStatsMBean(this.statisticsCache);
    }

    private record TableNamesCacheKey(IdentityCacheMapping.IdentityCacheKey identity, Optional<String> schemaName) {
        private TableNamesCacheKey {
            Objects.requireNonNull(identity, "identity is null");
            Objects.requireNonNull(schemaName, "schemaName is null");
        }
    }

    private record ColumnsCacheKey(IdentityCacheMapping.IdentityCacheKey identity, Map<String, Object> sessionProperties, SchemaTableName table) {
        private ColumnsCacheKey {
            Objects.requireNonNull(identity, "identity is null");
            sessionProperties = ImmutableMap.copyOf(Objects.requireNonNull(sessionProperties, "sessionProperties is null"));
            Objects.requireNonNull(table, "table is null");
        }
    }

    private record TableHandlesByNameCacheKey(IdentityCacheMapping.IdentityCacheKey identity, SchemaTableName tableName) {
        private TableHandlesByNameCacheKey {
            Objects.requireNonNull(identity, "identity is null");
            Objects.requireNonNull(tableName, "tableName is null");
        }
    }

    private record TableHandlesByQueryCacheKey(IdentityCacheMapping.IdentityCacheKey identity, PreparedQuery preparedQuery) {
        private TableHandlesByQueryCacheKey {
            Objects.requireNonNull(identity, "identity is null");
            Objects.requireNonNull(preparedQuery, "preparedQuery is null");
        }
    }

    private record ProcedureHandlesByQueryCacheKey(IdentityCacheMapping.IdentityCacheKey identity, JdbcProcedureHandle.ProcedureQuery procedureQuery) {
        private ProcedureHandlesByQueryCacheKey {
            Objects.requireNonNull(identity, "identity is null");
            Objects.requireNonNull(procedureQuery, "procedureQuery is null");
        }
    }
}

