/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Throwables;
import io.trino.Session;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.sql.TestTable;
import java.util.Locale;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class BaseJdbcTableStatisticsTest
extends AbstractTestQueryFramework {
    @BeforeAll
    public void setUpTables() {
        this.setUpTableFromTpch("region");
        this.setUpTableFromTpch("nation");
    }

    private void setUpTableFromTpch(String tableName) {
        block2: {
            this.computeActual("CREATE TABLE IF NOT EXISTS " + tableName + " AS TABLE tpch.tiny." + tableName);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM " + tableName))).matches("SELECT count(*) FROM tpch.tiny." + tableName);
            try {
                this.gatherStats(tableName);
            }
            catch (Exception e) {
                if (Throwables.getStackTraceAsString((Throwable)e).toLowerCase(Locale.ENGLISH).contains("there are already statistics on table")) break block2;
                throw e;
            }
        }
    }

    @Test
    public abstract void testNotAnalyzed();

    @Test
    public abstract void testBasic();

    @Test
    public void testEmptyTable() {
        String tableName = "test_stats_table_empty_" + TestingNames.randomNameSuffix();
        this.computeActual(String.format("CREATE TABLE %s AS SELECT orderkey, custkey, orderpriority, comment FROM tpch.tiny.orders WHERE false", tableName));
        try {
            this.gatherStats(tableName);
            this.checkEmptyTableStats(tableName);
        }
        finally {
            this.assertUpdate("DROP TABLE " + tableName);
        }
    }

    protected void checkEmptyTableStats(String tableName) {
        this.assertQuery("SHOW STATS FOR " + tableName, "VALUES ('orderkey', 0, 0, 1, null, null, null),('custkey', 0, 0, 1, null, null, null),('orderpriority', 0, 0, 1, null, null, null),('comment', 0, 0, 1, null, null, null),(null, null, null, null, 0, null, null)");
    }

    @Test
    public abstract void testAllNulls();

    @Test
    public abstract void testNullsFraction();

    @Test
    public abstract void testAverageColumnLength();

    @Test
    public abstract void testPartitionedTable();

    @Test
    public abstract void testView();

    @Test
    public abstract void testMaterializedView();

    @Test
    public void testCaseColumnNames() {
        this.testCaseColumnNames("TEST_STATS_MIXED_UNQUOTED_UPPER");
        this.testCaseColumnNames("test_stats_mixed_unquoted_lower");
        this.testCaseColumnNames("test_stats_mixed_uNQuoTeD_miXED");
        this.testCaseColumnNames("\"TEST_STATS_MIXED_QUOTED_UPPER\"");
        this.testCaseColumnNames("\"test_stats_mixed_quoted_lower\"");
        this.testCaseColumnNames("\"test_stats_mixed_QuoTeD_miXED\"");
    }

    protected abstract void testCaseColumnNames(String var1);

    @Test
    public abstract void testNumericCornerCases();

    @Test
    public void testStatsWithPredicatePushdown() {
        String query = "SELECT * FROM nation WHERE regionkey = 1";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(query))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR (" + query + ")"))).result().exceptColumns(new String[]{"data_size", "low_value", "high_value"}).skippingTypesCheck().matches("VALUES ('nationkey', 5e0, 0e0, null),('name', 5e0, 0e0, null),('regionkey', 1e0, 0e0, null),('comment', 5e0, 0e0, null),(null, null, null, 5e0)");
    }

    @Test
    public void testStatsWithVarcharPredicatePushdown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR (SELECT * FROM nation WHERE name = 'PERU')"))).result().exceptColumns(new String[]{"data_size", "low_value", "high_value"}).skippingTypesCheck().matches("VALUES ('nationkey', 1e0, 0e0, null),('name', 1e0, 0e0, null),('regionkey', 1e0, 0e0, null),('comment', 1e0, 0e0, null),(null, null, null, 1e0)");
        try (TestTable table = new TestTable(arg_0 -> ((QueryRunner)this.getQueryRunner()).execute(arg_0), "varchar_duplicates", " AS SELECT nationkey, chr(codepoint('A') + nationkey / 5) fl FROM  tpch.tiny.nation");){
            this.gatherStats(table.getName());
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR (SELECT * FROM " + table.getName() + " WHERE fl = 'B')"))).result().exceptColumns(new String[]{"data_size", "low_value", "high_value"}).skippingTypesCheck().matches("VALUES ('nationkey', 5e0, 0e0, null),('fl', 1e0, 0e0, null),(null, null, null, 5e0)");
        }
    }

    @Test
    public void testStatsWithPredicatePushdownWithStatsPrecalculationDisabled() {
        String query = "SELECT * FROM nation WHERE regionkey = 1";
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("statistics_precalculation_for_pushdown_enabled", "false").build();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, query))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(session, "SHOW STATS FOR (" + query + ")"))).result().exceptColumns(new String[]{"data_size", "low_value", "high_value"}).skippingTypesCheck().matches("VALUES ('nationkey', 25e0, 0e0, null),('name', 25e0, 0e0, null),('regionkey', 5e0, 0e0, null),('comment', 25e0, 0e0, null),(null, null, null, 25e0)");
    }

    @Test
    public void testStatsWithLimitPushdown() {
        String query = "SELECT regionkey, nationkey FROM nation LIMIT 2";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(query))).skipResultsCorrectnessCheckForPushdown().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR (" + query + ")"))).result().exceptColumns(new String[]{"data_size", "low_value", "high_value"}).skippingTypesCheck().matches("VALUES ('regionkey', 2e0, 0e0, null),('nationkey', 2e0, 0e0, null),(null, null, null, 2e0)");
    }

    @Test
    public void testStatsWithTopNPushdown() {
        String query = "SELECT regionkey, nationkey FROM nation ORDER BY regionkey LIMIT 2";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(query))).skipResultsCorrectnessCheckForPushdown().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR (" + query + ")"))).result().exceptColumns(new String[]{"data_size", "low_value", "high_value"}).skippingTypesCheck().matches("VALUES ('regionkey', 2e0, 0e0, null),('nationkey', 2e0, 0e0, null),(null, null, null, 2e0)");
    }

    @Test
    public void testStatsWithDistinctPushdown() {
        String query = "SELECT DISTINCT regionkey FROM nation";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(query))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR (" + query + ")"))).result().exceptColumns(new String[]{"data_size", "low_value", "high_value"}).skippingTypesCheck().matches("VALUES ('regionkey', 5e0, 0e0, null),(null, null, null, 5e0)");
    }

    @Test
    public void testStatsWithDistinctLimitPushdown() {
        String query = "SELECT DISTINCT regionkey FROM nation LIMIT 3";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(query))).skipResultsCorrectnessCheckForPushdown().isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR (" + query + ")"))).result().exceptColumns(new String[]{"data_size", "low_value", "high_value"}).skippingTypesCheck().matches("VALUES ('regionkey', 3e0, 0e0, null),(null, null, null, 3e0)");
    }

    @Test
    public void testStatsWithAggregationPushdown() {
        String query = "SELECT regionkey, max(nationkey) max_nationkey, count(*) c FROM nation GROUP BY regionkey";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(query))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR (" + query + ")"))).result().exceptColumns(new String[]{"data_size", "low_value", "high_value"}).skippingTypesCheck().matches("VALUES ('regionkey', 5e0, 0e0, null),('max_nationkey', null, null, null),('c', null, null, null),(null, null, null, 5e0)");
    }

    @Test
    public void testStatsWithSimpleJoinPushdown() {
        String query = "SELECT n.name n_name FROM nation n JOIN region r ON n.nationkey = r.regionkey";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(query))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR (" + query + ")"))).result().exceptColumns(new String[]{"data_size", "low_value", "high_value"}).skippingTypesCheck().matches("VALUES ('n_name', 5e0, 0e0, null),(null, null, null, 5e0)");
    }

    @Test
    public void testStatsWithJoinPushdown() {
        String query = "SELECT r.regionkey regionkey, r.name r_name, n.name n_name FROM region r JOIN nation n ON r.regionkey = n.regionkey WHERE n.nationkey = 5";
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(query))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR (" + query + ")"))).result().exceptColumns(new String[]{"data_size", "low_value", "high_value"}).skippingTypesCheck().matches("VALUES ('regionkey', 1e0, 0e0, null),('r_name', 1e0, 0e0, null),('n_name', 1e0, 0e0, null),(null, null, null, 1e0)");
    }

    protected abstract void gatherStats(String var1);
}

