/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import io.trino.plugin.base.mapping.RuleBasedIdentifierMappingUtils;
import io.trino.plugin.jdbc.JdbcPlugin;
import io.trino.plugin.jdbc.TestingH2JdbcModule;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.testing.TestingConnectorContext;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestJdbcPlugin {
    @Test
    public void testCreateConnector() {
        TestJdbcPlugin.getConnectorFactory().create("test", TestingH2JdbcModule.createProperties(), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    @Test
    public void testRuleBasedIdentifierCanBeUsedTogetherWithCacheBased() throws Exception {
        TestJdbcPlugin.getConnectorFactory().create("test", (Map)ImmutableMap.builder().putAll(TestingH2JdbcModule.createProperties()).put((Object)"case-insensitive-name-matching", (Object)"true").put((Object)"case-insensitive-name-matching.config-file", (Object)RuleBasedIdentifierMappingUtils.createRuleBasedIdentifierMappingFile().toFile().getAbsolutePath()).buildOrThrow(), (ConnectorContext)new TestingConnectorContext()).shutdown();
    }

    private static ConnectorFactory getConnectorFactory() {
        JdbcPlugin plugin = new JdbcPlugin("jdbc", (Module)new TestingH2JdbcModule());
        return (ConnectorFactory)Iterables.getOnlyElement((Iterable)plugin.getConnectorFactories());
    }
}

