/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.airlift.json.JsonCodec;
import io.trino.plugin.jdbc.CaseSensitivity;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJdbcTypeHandle {
    @Test
    public void testJsonSerialization() {
        JdbcTypeHandle input = new JdbcTypeHandle(10, Optional.of("jdbcTypeName"), Optional.of(10), Optional.of(10), Optional.of(10), Optional.of(CaseSensitivity.CASE_SENSITIVE));
        JsonCodec codec = JsonCodec.jsonCodec(JdbcTypeHandle.class);
        String json = codec.toJson((Object)input);
        Assertions.assertThat(((Map)JsonCodec.mapJsonCodec(String.class, Object.class).fromJson(json)).keySet()).containsExactlyInAnyOrder((Object[])new String[]{"jdbcType", "jdbcTypeName", "columnSize", "decimalDigits", "arrayDimensions", "caseSensitivity"});
        Assertions.assertThat((Object)((JdbcTypeHandle)codec.fromJson(json))).isEqualTo((Object)input);
    }
}

