/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.LazyConnectionFactory;
import io.trino.plugin.jdbc.RetryingConnectionFactoryModule;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.credential.EmptyCredentialProvider;
import io.trino.testing.TestingConnectorSession;
import java.sql.Connection;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.Assertions;
import org.h2.Driver;
import org.junit.jupiter.api.Test;

public class TestLazyConnectionFactory {
    @Test
    public void testNoConnectionIsCreated() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{binder -> {
            binder.bind(ConnectionFactory.class).annotatedWith(ForBaseJdbc.class).toInstance(session -> {
                throw new AssertionError((Object)"Expected no connection creation");
            });
            binder.install((Module)new RetryingConnectionFactoryModule());
        }});
        try (LazyConnectionFactory lazyConnectionFactory = (LazyConnectionFactory)injector.getInstance(LazyConnectionFactory.class);){
            Connection ignored = lazyConnectionFactory.openConnection(TestingConnectorSession.SESSION);
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    @Test
    public void testConnectionCannotBeReusedAfterClose() throws Exception {
        BaseJdbcConfig config = new BaseJdbcConfig().setConnectionUrl(String.format("jdbc:h2:mem:test%s;DB_CLOSE_DELAY=-1", System.nanoTime() + ThreadLocalRandom.current().nextLong()));
        Injector injector = Guice.createInjector((Module[])new Module[]{binder -> {
            binder.bind(ConnectionFactory.class).annotatedWith(ForBaseJdbc.class).toInstance((Object)DriverConnectionFactory.builder((java.sql.Driver)new Driver(), (String)config.getConnectionUrl(), (CredentialProvider)new EmptyCredentialProvider()).build());
            binder.install((Module)new RetryingConnectionFactoryModule());
        }});
        try (LazyConnectionFactory lazyConnectionFactory = (LazyConnectionFactory)injector.getInstance(LazyConnectionFactory.class);){
            Connection connection = lazyConnectionFactory.openConnection(TestingConnectorSession.SESSION);
            connection.close();
            Assertions.assertThatThrownBy(connection::createStatement).hasMessage("Connection is already closed");
        }
    }
}

