/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableSet;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import io.airlift.log.Logger;
import io.trino.plugin.base.aggregation.AggregateFunctionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.base.mapping.DefaultIdentifierMapping;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DefaultQueryBuilder;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcProcedureHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.aggregation.ImplementCountAll;
import io.trino.plugin.jdbc.expression.JdbcConnectorExpressionRewriterBuilder;
import io.trino.plugin.jdbc.expression.RewriteVariable;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class TestingH2JdbcClient
extends BaseJdbcClient {
    private static final Logger log = Logger.get(TestingH2JdbcClient.class);
    private static final JdbcTypeHandle BIGINT_TYPE_HANDLE = new JdbcTypeHandle(-5, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private static final int MAXIMUM_VARCHAR_LENGTH = 1000000000;

    public TestingH2JdbcClient(BaseJdbcConfig config, ConnectionFactory connectionFactory) {
        this(config, connectionFactory, (QueryBuilder)new DefaultQueryBuilder(RemoteQueryModifier.NONE), (IdentifierMapping)new DefaultIdentifierMapping());
    }

    public TestingH2JdbcClient(BaseJdbcConfig config, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, IdentifierMapping identifierMapping) {
        super("\"", connectionFactory, queryBuilder, config.getJdbcTypesMappedToVarchar(), identifierMapping, RemoteQueryModifier.NONE, false);
    }

    public Collection<String> listSchemas(Connection connection) {
        return (Collection)Failsafe.with((Policy)RetryPolicy.builder().withMaxAttempts(100).onRetry(event -> log.warn(event.getLastException(), "Failed to list schemas, retrying")).build(), (Policy[])new RetryPolicy[0]).get(() -> super.listSchemas(connection));
    }

    public Optional<String> getTableComment(ResultSet resultSet) {
        return Optional.empty();
    }

    public void setColumnComment(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Optional<String> comment) {
        if (comment.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting column comments");
        }
    }

    public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return groupingSets.size() == 1;
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return new AggregateFunctionRewriter(JdbcConnectorExpressionRewriterBuilder.newBuilder().add((ConnectorExpressionRule)new RewriteVariable(arg_0 -> ((TestingH2JdbcClient)this).quoted(arg_0))).build(), (Set)ImmutableSet.of((Object)new ImplementCountAll(BIGINT_TYPE_HANDLE))).rewrite(session, aggregate, assignments);
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        switch (typeHandle.jdbcType()) {
            case 16: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case -6: {
                return Optional.of(StandardColumnMappings.tinyintColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 6: 
            case 7: {
                return Optional.of(StandardColumnMappings.realColumnMapping());
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 1: {
                return Optional.of(StandardColumnMappings.defaultCharColumnMapping((int)typeHandle.requiredColumnSize(), (boolean)true));
            }
            case 12: {
                if (typeHandle.requiredColumnSize() == 1000000000) {
                    return Optional.of(StandardColumnMappings.varcharColumnMapping((VarcharType)VarcharType.createUnboundedVarcharType(), (boolean)true));
                }
                return Optional.of(StandardColumnMappings.defaultVarcharColumnMapping((int)typeHandle.requiredColumnSize(), (boolean)true));
            }
            case 91: {
                return Optional.of(StandardColumnMappings.dateColumnMappingUsingSqlDate());
            }
            case 92: {
                return Optional.of(StandardColumnMappings.timeColumnMapping((TimeType)TimeType.TIME_MILLIS));
            }
            case 93: {
                TimestampType timestampType = typeHandle.decimalDigits().map(TimestampType::createTimestampType).orElse(TimestampType.TIMESTAMP_MILLIS);
                return Optional.of(StandardColumnMappings.timestampColumnMapping((TimestampType)timestampType));
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return TestingH2JdbcClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
        }
        return Optional.empty();
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"tinyint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"integer", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type == RealType.REAL) {
            return WriteMapping.longMapping((String)"float", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"double precision", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            String dataType = varcharType.isUnbounded() ? "varchar" : "varchar(" + varcharType.getBoundedLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            String dataType = "char(" + charType.getLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.charWriteFunction());
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"date", (LongWriteFunction)StandardColumnMappings.dateWriteFunctionUsingSqlDate());
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    protected void renameTable(ConnectorSession session, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        if (!schemaName.equalsIgnoreCase(newTable.getSchemaName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables across schemas");
        }
        super.renameTable(session, catalogName, schemaName, tableName, newTable);
    }

    /*
     * Exception decompiling
     */
    public JdbcProcedureHandle getProcedureHandle(ConnectorSession session, JdbcProcedureHandle.ProcedureQuery procedureQuery) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

