/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.credential.keystore;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.jdbc.credential.keystore.KeyStoreBasedCredentialProviderConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestKeyStoreBasedCredentialProviderConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((KeyStoreBasedCredentialProviderConfig)ConfigAssertions.recordDefaults(KeyStoreBasedCredentialProviderConfig.class)).setKeyStoreFilePath(null).setKeyStoreType(null).setKeyStorePassword(null).setUserCredentialName(null).setPasswordForUserCredentialName(null).setPasswordCredentialName(null).setPasswordForPasswordCredentialName(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path keystoreFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"keystore-file-path", (Object)keystoreFile.toString()).put((Object)"keystore-type", (Object)"JCEKS").put((Object)"keystore-password", (Object)"keystore_password").put((Object)"keystore-user-credential-name", (Object)"userName").put((Object)"keystore-user-credential-password", (Object)"keystore_password_for_user_name").put((Object)"keystore-password-credential-name", (Object)"password").put((Object)"keystore-password-credential-password", (Object)"keystore_password_for_password").buildOrThrow();
        KeyStoreBasedCredentialProviderConfig expected = new KeyStoreBasedCredentialProviderConfig().setKeyStoreFilePath(keystoreFile.toString()).setKeyStoreType("JCEKS").setKeyStorePassword("keystore_password").setUserCredentialName("userName").setPasswordForUserCredentialName("keystore_password_for_user_name").setPasswordCredentialName("password").setPasswordForPasswordCredentialName("keystore_password_for_password");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

