/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.base.ClosingBinder;
import io.trino.plugin.base.mapping.IdentifierMappingModule;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.CachingJdbcClient;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DefaultJdbcMetadataFactory;
import io.trino.plugin.jdbc.DefaultQueryBuilder;
import io.trino.plugin.jdbc.DynamicFilteringStats;
import io.trino.plugin.jdbc.ForJdbcDynamicFiltering;
import io.trino.plugin.jdbc.ForRecordCursor;
import io.trino.plugin.jdbc.IdentityCacheMapping;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcConnector;
import io.trino.plugin.jdbc.JdbcDiagnosticModule;
import io.trino.plugin.jdbc.JdbcDynamicFilteringConfig;
import io.trino.plugin.jdbc.JdbcDynamicFilteringSessionProperties;
import io.trino.plugin.jdbc.JdbcDynamicFilteringSplitManager;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.JdbcMetadataFactory;
import io.trino.plugin.jdbc.JdbcMetadataSessionProperties;
import io.trino.plugin.jdbc.JdbcPageSinkProvider;
import io.trino.plugin.jdbc.JdbcQueryEventListener;
import io.trino.plugin.jdbc.JdbcRecordSetProvider;
import io.trino.plugin.jdbc.JdbcSplitManager;
import io.trino.plugin.jdbc.JdbcTransactionManager;
import io.trino.plugin.jdbc.JdbcWriteConfig;
import io.trino.plugin.jdbc.JdbcWriteSessionProperties;
import io.trino.plugin.jdbc.LazyConnectionFactory;
import io.trino.plugin.jdbc.MaxDomainCompactionThreshold;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.QueryConfig;
import io.trino.plugin.jdbc.RetryingConnectionFactoryModule;
import io.trino.plugin.jdbc.ReusableConnectionFactoryModule;
import io.trino.plugin.jdbc.SingletonIdentityCacheMapping;
import io.trino.plugin.jdbc.TablePropertiesProvider;
import io.trino.plugin.jdbc.TimestampTimeZoneDomain;
import io.trino.plugin.jdbc.TypeHandlingJdbcConfig;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.logging.RemoteQueryModifierModule;
import io.trino.plugin.jdbc.procedure.ExecuteProcedure;
import io.trino.plugin.jdbc.procedure.FlushJdbcMetadataCacheProcedure;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.procedure.Procedure;
import java.util.concurrent.ExecutorService;
import org.weakref.jmx.guice.ExportBinder;

public class JdbcModule
extends AbstractConfigurationAwareModule {
    public void setup(Binder binder) {
        this.install(new JdbcDiagnosticModule());
        this.install((Module)new IdentifierMappingModule());
        this.install((Module)new RemoteQueryModifierModule());
        this.install((Module)new RetryingConnectionFactoryModule());
        OptionalBinder.newOptionalBinder((Binder)binder, ConnectorAccessControl.class);
        OptionalBinder.newOptionalBinder((Binder)binder, QueryBuilder.class).setDefault().to(DefaultQueryBuilder.class).in(Scopes.SINGLETON);
        JdbcModule.procedureBinder(binder);
        JdbcModule.tablePropertiesProviderBinder(binder);
        OptionalBinder.newOptionalBinder((Binder)binder, JdbcMetadataFactory.class).setDefault().to(DefaultJdbcMetadataFactory.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, IdentityCacheMapping.class).setDefault().to(SingletonIdentityCacheMapping.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, TimestampTimeZoneDomain.class).setDefault().toInstance((Object)TimestampTimeZoneDomain.ANY);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(ConnectorSplitManager.class, ForJdbcDynamicFiltering.class)).setDefault().to(JdbcSplitManager.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, ConnectorSplitManager.class).setDefault().to(JdbcDynamicFilteringSplitManager.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, ConnectorRecordSetProvider.class).setDefault().to(JdbcRecordSetProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, ConnectorPageSinkProvider.class).setDefault().to(JdbcPageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(JdbcTransactionManager.class).in(Scopes.SINGLETON);
        binder.bind(JdbcConnector.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcMetadataConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcWriteConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(BaseJdbcConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcDynamicFilteringConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(TypeHandlingJdbcConfig.class);
        JdbcModule.bindSessionPropertiesProvider(binder, TypeHandlingJdbcSessionProperties.class);
        JdbcModule.bindSessionPropertiesProvider(binder, JdbcMetadataSessionProperties.class);
        JdbcModule.bindSessionPropertiesProvider(binder, JdbcWriteSessionProperties.class);
        JdbcModule.bindSessionPropertiesProvider(binder, JdbcDynamicFilteringSessionProperties.class);
        binder.bind(DynamicFilteringStats.class).in(Scopes.SINGLETON);
        Provider catalogName = binder.getProvider(CatalogName.class);
        ExportBinder.newExporter((Binder)binder).export(DynamicFilteringStats.class).as(generator -> generator.generatedNameOf(DynamicFilteringStats.class, ((CatalogName)catalogName.get()).toString()));
        binder.bind(CachingJdbcClient.class).in(Scopes.SINGLETON);
        binder.bind(JdbcClient.class).to(Key.get(CachingJdbcClient.class)).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, Procedure.class).addBinding().toProvider(FlushJdbcMetadataCacheProcedure.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, Procedure.class).addBinding().toProvider(ExecuteProcedure.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class);
        this.install(ConditionalModule.conditionalModule(QueryConfig.class, QueryConfig::isReuseConnection, (Module)new ReusableConnectionFactoryModule(), innerBinder -> innerBinder.bind(ConnectionFactory.class).to(LazyConnectionFactory.class).in(Scopes.SINGLETON)));
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Integer.TYPE, MaxDomainCompactionThreshold.class));
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(ExecutorService.class, ForRecordCursor.class)).setDefault().toProvider(MoreExecutors::newDirectExecutorService).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, JdbcQueryEventListener.class);
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ExecutorService.class, ForRecordCursor.class));
    }

    public static Multibinder<SessionPropertiesProvider> sessionPropertiesProviderBinder(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, SessionPropertiesProvider.class);
    }

    public static void bindSessionPropertiesProvider(Binder binder, Class<? extends SessionPropertiesProvider> type) {
        JdbcModule.sessionPropertiesProviderBinder(binder).addBinding().to(type).in(Scopes.SINGLETON);
    }

    public static Multibinder<Procedure> procedureBinder(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, Procedure.class);
    }

    public static void bindProcedure(Binder binder, Class<? extends Provider<? extends Procedure>> type) {
        JdbcModule.procedureBinder(binder).addBinding().toProvider(type).in(Scopes.SINGLETON);
    }

    public static Multibinder<TablePropertiesProvider> tablePropertiesProviderBinder(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, TablePropertiesProvider.class);
    }

    public static void bindTablePropertiesProvider(Binder binder, Class<? extends TablePropertiesProvider> type) {
        JdbcModule.tablePropertiesProviderBinder(binder).addBinding().to(type).in(Scopes.SINGLETON);
    }
}

