/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.testing.Closeables;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TemporaryRelation;
import io.trino.testing.sql.TestTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class CastDataTypeTestTable
implements TemporaryRelation {
    private final List<TestCaseInput> testCaseRows = new ArrayList<TestCaseInput>();
    private final int rowCount;
    private TestTable testTable;

    private CastDataTypeTestTable(int rowCount) {
        this.rowCount = rowCount;
    }

    public static CastDataTypeTestTable create(int rowCount) {
        return new CastDataTypeTestTable(rowCount);
    }

    public CastDataTypeTestTable addColumn(String columnName, String columnType, List<Object> inputValues) {
        Preconditions.checkArgument((this.rowCount == inputValues.size() ? 1 : 0) != 0, (String)"Expected input size: %s, but found: %s", (int)this.rowCount, (int)inputValues.size());
        this.testCaseRows.add(new TestCaseInput(columnName, columnType, inputValues));
        return this;
    }

    public CastDataTypeTestTable execute(SqlExecutor sqlExecutor, String tableNamePrefix) {
        Preconditions.checkState((!this.testCaseRows.isEmpty() ? 1 : 0) != 0, (Object)"No test case rows");
        ArrayList<String> columnsWithType = new ArrayList<String>();
        for (TestCaseInput input : this.testCaseRows) {
            columnsWithType.add("%s %s".formatted(input.columnName(), input.columnType()));
        }
        String tableDefinition = columnsWithType.stream().collect(Collectors.joining(", ", "(", ")"));
        List rowsToInsert = (List)IntStream.range(0, this.rowCount).mapToObj(rowId -> this.testCaseRows.stream().map(TestCaseInput::inputValues).map(rows -> rows.get(rowId)).map(String::valueOf).collect(Collectors.joining(","))).collect(ImmutableList.toImmutableList());
        this.testTable = new TestTable(sqlExecutor, tableNamePrefix, tableDefinition, rowsToInsert);
        return this;
    }

    public String getName() {
        return this.testTable.getName();
    }

    public void close() {
        try {
            Closeables.closeAll((AutoCloseable[])new AutoCloseable[]{this.testTable});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public record TestCaseInput(String columnName, String columnType, List<Object> inputValues) {
        public TestCaseInput {
            Objects.requireNonNull(columnName, "columnName is null");
            Objects.requireNonNull(columnType, "columnType is null");
            inputValues = new ArrayList<Object>((Collection)Objects.requireNonNull(inputValues, "inputValues is null"));
        }
    }
}

