/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.trino.plugin.jdbc.RemoteDatabaseEvent;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class RemoteLogTracingEvent
implements Consumer<RemoteDatabaseEvent> {
    private final Predicate<RemoteDatabaseEvent> condition;
    private final AtomicBoolean happened;

    public RemoteLogTracingEvent(Predicate<RemoteDatabaseEvent> condition) {
        this.condition = Objects.requireNonNull(condition, "condition is null");
        this.happened = new AtomicBoolean();
    }

    public boolean hasHappened() {
        return this.happened.get();
    }

    @Override
    public void accept(RemoteDatabaseEvent remoteDatabaseEvent) {
        if (this.hasHappened()) {
            return;
        }
        if (this.condition.test(remoteDatabaseEvent)) {
            this.happened.compareAndSet(false, true);
        }
    }
}

