/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.trino.plugin.jdbc.DefaultJdbcMetadata;
import io.trino.plugin.jdbc.ForwardingJdbcClient;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import io.trino.plugin.jdbc.JdbcMetadataSessionProperties;
import io.trino.plugin.jdbc.JdbcQueryRelationHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.TestingDatabase;
import io.trino.plugin.jdbc.TestingJdbcTypeHandle;
import io.trino.plugin.jdbc.TimestampTimeZoneDomain;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestDefaultJdbcMetadata {
    private TestingDatabase database;
    private DefaultJdbcMetadata metadata;
    private JdbcTableHandle tableHandle;

    @BeforeEach
    public void setUp() throws Exception {
        this.database = new TestingDatabase();
        this.metadata = new DefaultJdbcMetadata((JdbcClient)new GroupingSetsEnabledJdbcClient(this.database.getJdbcClient(), Optional.empty()), TimestampTimeZoneDomain.ANY, false, (Set)ImmutableSet.of());
        this.tableHandle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("example", "numbers"), Optional.empty(), Optional.empty());
    }

    @Test
    public void testSupportsRetriesValidation() {
        this.metadata = new DefaultJdbcMetadata((JdbcClient)new GroupingSetsEnabledJdbcClient(this.database.getJdbcClient(), Optional.of(false)), TimestampTimeZoneDomain.ANY, false, (Set)ImmutableSet.of());
        ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(new SchemaTableName("example", "numbers"), (List)ImmutableList.of());
        Assertions.assertThatThrownBy(() -> this.metadata.beginCreateTable(TestingConnectorSession.SESSION, tableMetadata, Optional.empty(), RetryMode.RETRIES_ENABLED, false)).hasMessageContaining("This connector does not support query or task retries");
        Assertions.assertThatThrownBy(() -> this.metadata.beginInsert(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle, (List)ImmutableList.of(), RetryMode.RETRIES_ENABLED)).hasMessageContaining("This connector does not support query or task retries");
    }

    @Test
    public void testNonTransactionalInsertValidation() {
        this.metadata = new DefaultJdbcMetadata((JdbcClient)new GroupingSetsEnabledJdbcClient(this.database.getJdbcClient(), Optional.of(true)), TimestampTimeZoneDomain.ANY, false, (Set)ImmutableSet.of());
        ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(new SchemaTableName("example", "numbers"), (List)ImmutableList.of());
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata((List)ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)"non_transactional_insert", (String)"description", (Boolean)true, (boolean)false))).build();
        Assertions.assertThatThrownBy(() -> this.lambda$testNonTransactionalInsertValidation$2((ConnectorSession)session, tableMetadata)).hasMessageContaining("Query and task retries are incompatible with non-transactional inserts");
        Assertions.assertThatThrownBy(() -> this.lambda$testNonTransactionalInsertValidation$3((ConnectorSession)session)).hasMessageContaining("Query and task retries are incompatible with non-transactional inserts");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.database.close();
        this.database = null;
    }

    @Test
    public void testListSchemaNames() {
        Assertions.assertThat((List)this.metadata.listSchemaNames(TestingConnectorSession.SESSION)).containsAll((Iterable)ImmutableSet.of((Object)"example", (Object)"tpch"));
    }

    @Test
    public void testGetTableHandle() {
        JdbcTableHandle tableHandle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("example", "numbers"), Optional.empty(), Optional.empty());
        Assertions.assertThat((Object)this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("example", "numbers"), Optional.empty(), Optional.empty())).isEqualTo((Object)tableHandle);
        Assertions.assertThat((Object)this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("example", "unknown"), Optional.empty(), Optional.empty())).isNull();
        Assertions.assertThat((Object)this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("unknown", "numbers"), Optional.empty(), Optional.empty())).isNull();
        Assertions.assertThat((Object)this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("unknown", "unknown"), Optional.empty(), Optional.empty())).isNull();
    }

    @Test
    public void testGetColumnHandles() {
        Assertions.assertThat((Map)this.metadata.getColumnHandles(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle)).isEqualTo((Object)ImmutableMap.of((Object)"text", (Object)new JdbcColumnHandle("TEXT", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), (Object)"text_short", (Object)new JdbcColumnHandle("TEXT_SHORT", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.createVarcharType((int)32)), (Object)"value", (Object)new JdbcColumnHandle("VALUE", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT)));
        this.unknownTableColumnHandle(new JdbcTableHandle(new SchemaTableName("unknown", "unknown"), new RemoteTableName(Optional.of("unknown"), Optional.of("unknown"), "unknown"), Optional.empty()));
        this.unknownTableColumnHandle(new JdbcTableHandle(new SchemaTableName("example", "numbers"), new RemoteTableName(Optional.empty(), Optional.of("example"), "unknown"), Optional.empty()));
    }

    private void unknownTableColumnHandle(JdbcTableHandle tableHandle) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.metadata.getColumnHandles(TestingConnectorSession.SESSION, (ConnectorTableHandle)tableHandle)).isInstanceOf(TableNotFoundException.class)).hasMessage("Table '%s' has no supported columns (all 0 columns are not supported)", new Object[]{tableHandle.asPlainTable().getSchemaTableName()});
    }

    @Test
    public void getTableMetadata() {
        ConnectorTableMetadata tableMetadata = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle);
        Assertions.assertThat((Object)tableMetadata.getTable()).isEqualTo((Object)new SchemaTableName("example", "numbers"));
        Assertions.assertThat((List)tableMetadata.getColumns()).isEqualTo((Object)ImmutableList.of((Object)ColumnMetadata.builder().setName("text").setType((Type)VarcharType.VARCHAR).setNullable(false).build(), (Object)new ColumnMetadata("text_short", (Type)VarcharType.createVarcharType((int)32)), (Object)new ColumnMetadata("value", (Type)BigintType.BIGINT)));
        JdbcTableHandle specialTableHandle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, new SchemaTableName("exa_ple", "num_ers"), Optional.empty(), Optional.empty());
        ConnectorTableMetadata specialTableMetadata = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)specialTableHandle);
        Assertions.assertThat((Object)specialTableMetadata.getTable()).isEqualTo((Object)new SchemaTableName("exa_ple", "num_ers"));
        Assertions.assertThat((List)specialTableMetadata.getColumns()).isEqualTo((Object)ImmutableList.of((Object)ColumnMetadata.builder().setName("te_t").setType((Type)VarcharType.VARCHAR).setNullable(false).build(), (Object)new ColumnMetadata("va%ue", (Type)BigintType.BIGINT)));
        this.unknownTableMetadata(new JdbcTableHandle(new SchemaTableName("u", "numbers"), new RemoteTableName(Optional.empty(), Optional.of("unknown"), "unknown"), Optional.empty()));
        this.unknownTableMetadata(new JdbcTableHandle(new SchemaTableName("example", "numbers"), new RemoteTableName(Optional.empty(), Optional.of("example"), "unknown"), Optional.empty()));
        this.unknownTableMetadata(new JdbcTableHandle(new SchemaTableName("example", "numbers"), new RemoteTableName(Optional.empty(), Optional.of("unknown"), "numbers"), Optional.empty()));
    }

    private void unknownTableMetadata(JdbcTableHandle tableHandle) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)tableHandle)).isInstanceOf(TableNotFoundException.class)).hasMessage("Table '%s' has no supported columns (all 0 columns are not supported)", new Object[]{tableHandle.asPlainTable().getSchemaTableName()});
    }

    @Test
    public void testListTables() {
        Assertions.assertThat((List)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.empty())).containsOnly((Object[])new SchemaTableName[]{new SchemaTableName("example", "numbers"), new SchemaTableName("example", "timestamps"), new SchemaTableName("example", "view_source"), new SchemaTableName("example", "view"), new SchemaTableName("tpch", "orders"), new SchemaTableName("tpch", "lineitem"), new SchemaTableName("exa_ple", "table_with_float_col"), new SchemaTableName("exa_ple", "num_ers")});
        Assertions.assertThat((List)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("example"))).containsOnly((Object[])new SchemaTableName[]{new SchemaTableName("example", "numbers"), new SchemaTableName("example", "timestamps"), new SchemaTableName("example", "view_source"), new SchemaTableName("example", "view")});
        Assertions.assertThat((List)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("tpch"))).containsOnly((Object[])new SchemaTableName[]{new SchemaTableName("tpch", "orders"), new SchemaTableName("tpch", "lineitem")});
        Assertions.assertThat((List)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("exa_ple"))).containsOnly((Object[])new SchemaTableName[]{new SchemaTableName("exa_ple", "num_ers"), new SchemaTableName("exa_ple", "table_with_float_col")});
        Assertions.assertThat((Collection)ImmutableSet.copyOf((Collection)this.metadata.listTables(TestingConnectorSession.SESSION, Optional.of("unknown")))).isEmpty();
    }

    @Test
    public void getColumnMetadata() {
        Assertions.assertThat((Object)this.metadata.getColumnMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle, (ColumnHandle)new JdbcColumnHandle("text", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR))).isEqualTo((Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR));
    }

    @Test
    public void testCreateAndAlterTable() {
        SchemaTableName table = new SchemaTableName("example", "foo");
        this.metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(table, (List)ImmutableList.of((Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR))), SaveMode.FAIL);
        JdbcTableHandle handle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, table, Optional.empty(), Optional.empty());
        ConnectorTableMetadata layout = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle);
        Assertions.assertThat((Object)layout.getTable()).isEqualTo((Object)table);
        Assertions.assertThat((List)layout.getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("text", (Type)VarcharType.VARCHAR)});
        this.metadata.addColumn(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle, new ColumnMetadata("x", (Type)VarcharType.VARCHAR));
        layout = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle);
        Assertions.assertThat((List)layout.getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("text", (Type)VarcharType.VARCHAR), new ColumnMetadata("x", (Type)VarcharType.VARCHAR)});
        JdbcColumnHandle columnHandle = new JdbcColumnHandle("x", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR);
        this.metadata.dropColumn(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle, (ColumnHandle)columnHandle);
        layout = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle);
        Assertions.assertThat((List)layout.getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("text", (Type)VarcharType.VARCHAR)});
        SchemaTableName newTableName = new SchemaTableName("example", "bar");
        this.metadata.renameTable(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle, newTableName);
        handle = this.metadata.getTableHandle(TestingConnectorSession.SESSION, newTableName, Optional.empty(), Optional.empty());
        layout = this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)handle);
        Assertions.assertThat((Object)layout.getTable()).isEqualTo((Object)newTableName);
        Assertions.assertThat((List)layout.getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("text", (Type)VarcharType.VARCHAR)});
    }

    @Test
    public void testDropTableTable() {
        this.metadata.dropTable(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.metadata.getTableMetadata(TestingConnectorSession.SESSION, (ConnectorTableHandle)this.tableHandle)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_FOUND});
    }

    @Test
    public void testAggregationPushdownForTableHandle() {
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig().setAggregationPushdownEnabled(true), Optional.empty()).getSessionProperties()).build();
        ColumnHandle groupByColumn = (ColumnHandle)this.metadata.getColumnHandles((ConnectorSession)session, (ConnectorTableHandle)this.tableHandle).get("text");
        Function<ConnectorTableHandle, Optional> applyAggregation = arg_0 -> this.lambda$testAggregationPushdownForTableHandle$7((ConnectorSession)session, groupByColumn, arg_0);
        JdbcTableHandle baseTableHandle = this.metadata.getTableHandle((ConnectorSession)session, new SchemaTableName("example", "numbers"), Optional.empty(), Optional.empty());
        Optional aggregationResult = applyAggregation.apply((ConnectorTableHandle)baseTableHandle);
        Assertions.assertThat((Optional)aggregationResult).isPresent();
        SchemaTableName noAggregationPushdownTable = new SchemaTableName("example", "no_aggregation_pushdown");
        this.metadata.createTable(TestingConnectorSession.SESSION, new ConnectorTableMetadata(noAggregationPushdownTable, (List)ImmutableList.of((Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR))), SaveMode.FAIL);
        JdbcTableHandle noAggregationPushdownTableHandle = this.metadata.getTableHandle((ConnectorSession)session, noAggregationPushdownTable, Optional.empty(), Optional.empty());
        aggregationResult = applyAggregation.apply((ConnectorTableHandle)noAggregationPushdownTableHandle);
        Assertions.assertThat((Optional)aggregationResult).isEmpty();
    }

    @Test
    public void testApplyFilterAfterAggregationPushdown() {
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig().setAggregationPushdownEnabled(true), Optional.empty()).getSessionProperties()).build();
        ColumnHandle groupByColumn = (ColumnHandle)this.metadata.getColumnHandles((ConnectorSession)session, (ConnectorTableHandle)this.tableHandle).get("text");
        JdbcTableHandle baseTableHandle = this.metadata.getTableHandle((ConnectorSession)session, new SchemaTableName("example", "numbers"), Optional.empty(), Optional.empty());
        JdbcTableHandle aggregatedTable = this.applyCountAggregation((ConnectorSession)session, (ConnectorTableHandle)baseTableHandle, (List<List<ColumnHandle>>)ImmutableList.of((Object)ImmutableList.of((Object)groupByColumn)));
        Domain domain = Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"one"));
        JdbcTableHandle tableHandleWithFilter = this.applyFilter((ConnectorSession)session, (ConnectorTableHandle)aggregatedTable, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)groupByColumn, (Object)domain))));
        Assertions.assertThat((Optional)tableHandleWithFilter.getConstraint().getDomains()).isEqualTo(Optional.of(ImmutableMap.of((Object)groupByColumn, (Object)domain)));
    }

    @Test
    public void testCombineFiltersWithAggregationPushdown() {
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig().setAggregationPushdownEnabled(true), Optional.empty()).getSessionProperties()).build();
        ColumnHandle groupByColumn = (ColumnHandle)this.metadata.getColumnHandles((ConnectorSession)session, (ConnectorTableHandle)this.tableHandle).get("text");
        JdbcTableHandle baseTableHandle = this.metadata.getTableHandle((ConnectorSession)session, new SchemaTableName("example", "numbers"), Optional.empty(), Optional.empty());
        Domain firstDomain = Domain.multipleValues((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"one"), (Object)Slices.utf8Slice((String)"two")));
        JdbcTableHandle filterResult = this.applyFilter((ConnectorSession)session, (ConnectorTableHandle)baseTableHandle, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)groupByColumn, (Object)firstDomain))));
        JdbcTableHandle aggregatedTable = this.applyCountAggregation((ConnectorSession)session, (ConnectorTableHandle)filterResult, (List<List<ColumnHandle>>)ImmutableList.of((Object)ImmutableList.of((Object)groupByColumn)));
        Domain secondDomain = Domain.multipleValues((Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)Slices.utf8Slice((String)"one"), (Object)Slices.utf8Slice((String)"three")));
        JdbcTableHandle tableHandleWithFilter = this.applyFilter((ConnectorSession)session, (ConnectorTableHandle)aggregatedTable, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)groupByColumn, (Object)secondDomain))));
        Assertions.assertThat((Optional)tableHandleWithFilter.getConstraint().getDomains()).isEqualTo(Optional.of(ImmutableMap.of((Object)groupByColumn, (Object)secondDomain)));
        Assertions.assertThat((String)((JdbcQueryRelationHandle)tableHandleWithFilter.getRelationHandle()).getPreparedQuery().query()).isEqualTo("SELECT \"TEXT\", count(*) AS \"_pfgnrtd_0\" FROM \"" + this.database.getDatabaseName() + "\".\"EXAMPLE\".\"NUMBERS\" WHERE \"TEXT\" IN (?,?) GROUP BY \"TEXT\"");
    }

    @Test
    public void testNonGroupKeyPredicatePushdown() {
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig().setAggregationPushdownEnabled(true), Optional.empty()).getSessionProperties()).build();
        Map columnHandles = this.metadata.getColumnHandles((ConnectorSession)session, (ConnectorTableHandle)this.tableHandle);
        ColumnHandle groupByColumn = (ColumnHandle)columnHandles.get("text");
        ColumnHandle nonGroupByColumn = (ColumnHandle)columnHandles.get("value");
        JdbcTableHandle baseTableHandle = this.metadata.getTableHandle((ConnectorSession)session, new SchemaTableName("example", "numbers"), Optional.empty(), Optional.empty());
        JdbcTableHandle aggregatedTable = this.applyCountAggregation((ConnectorSession)session, (ConnectorTableHandle)baseTableHandle, (List<List<ColumnHandle>>)ImmutableList.of((Object)ImmutableList.of((Object)groupByColumn)));
        Domain domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)123L);
        JdbcTableHandle tableHandleWithFilter = this.applyFilter((ConnectorSession)session, (ConnectorTableHandle)aggregatedTable, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)nonGroupByColumn, (Object)domain))));
        Assertions.assertThat((Optional)tableHandleWithFilter.getConstraint().getDomains()).isEqualTo(Optional.of(ImmutableMap.of((Object)nonGroupByColumn, (Object)domain)));
        Assertions.assertThat((String)((JdbcQueryRelationHandle)tableHandleWithFilter.getRelationHandle()).getPreparedQuery().query()).isEqualTo("SELECT \"TEXT\", count(*) AS \"_pfgnrtd_0\" FROM \"" + this.database.getDatabaseName() + "\".\"EXAMPLE\".\"NUMBERS\" GROUP BY \"TEXT\"");
    }

    @Test
    public void testMultiGroupKeyPredicatePushdown() {
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig().setAggregationPushdownEnabled(true), Optional.empty()).getSessionProperties()).build();
        Map columnHandles = this.metadata.getColumnHandles((ConnectorSession)session, (ConnectorTableHandle)this.tableHandle);
        ColumnHandle textColumn = (ColumnHandle)columnHandles.get("text");
        ColumnHandle valueColumn = (ColumnHandle)columnHandles.get("value");
        JdbcTableHandle baseTableHandle = this.metadata.getTableHandle((ConnectorSession)session, new SchemaTableName("example", "numbers"), Optional.empty(), Optional.empty());
        JdbcTableHandle aggregatedTable = this.applyCountAggregation((ConnectorSession)session, (ConnectorTableHandle)baseTableHandle, (List<List<ColumnHandle>>)ImmutableList.of((Object)ImmutableList.of((Object)textColumn, (Object)valueColumn), (Object)ImmutableList.of((Object)textColumn)));
        Domain domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)123L);
        JdbcTableHandle tableHandleWithFilter = this.applyFilter((ConnectorSession)session, (ConnectorTableHandle)aggregatedTable, new Constraint(TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)valueColumn, (Object)domain))));
        Assertions.assertThat((Optional)tableHandleWithFilter.getConstraint().getDomains()).isEqualTo(Optional.of(ImmutableMap.of((Object)valueColumn, (Object)domain)));
        Assertions.assertThat((String)((JdbcQueryRelationHandle)tableHandleWithFilter.getRelationHandle()).getPreparedQuery().query()).isEqualTo("SELECT \"TEXT\", \"VALUE\", count(*) AS \"_pfgnrtd_0\" FROM \"" + this.database.getDatabaseName() + "\".\"EXAMPLE\".\"NUMBERS\" GROUP BY GROUPING SETS ((\"TEXT\", \"VALUE\"), (\"TEXT\"))");
    }

    @Test
    public void testApplyTableScanRedirect() {
        TableScanRedirectApplicationResult tableScanRedirectApplicationResult = new TableScanRedirectApplicationResult(new CatalogSchemaTableName("target_catalog", "targert_schema", "target_table"), (Map)ImmutableMap.of(), TupleDomain.all());
        this.metadata = new DefaultJdbcMetadata((JdbcClient)new GroupingSetsEnabledJdbcClient(this.database.getJdbcClient(), Optional.empty(), Optional.of(tableScanRedirectApplicationResult)), TimestampTimeZoneDomain.ANY, false, (Set)ImmutableSet.of());
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(new JdbcMetadataSessionProperties(new JdbcMetadataConfig().setAggregationPushdownEnabled(true), Optional.empty()).getSessionProperties()).build();
        JdbcTableHandle baseTableHandle = this.metadata.getTableHandle((ConnectorSession)session, new SchemaTableName("example", "numbers"), Optional.empty(), Optional.empty());
        Assertions.assertThat((Optional)this.metadata.applyTableScanRedirect((ConnectorSession)session, (ConnectorTableHandle)baseTableHandle)).hasValueSatisfying(actualResult -> {
            Assertions.assertThat((Object)actualResult.getDestinationTable()).isEqualTo((Object)tableScanRedirectApplicationResult.getDestinationTable());
            Assertions.assertThat((Map)actualResult.getDestinationColumns()).isEmpty();
            Assertions.assertThat((Object)actualResult.getFilter()).isEqualTo((Object)TupleDomain.all());
        });
        JdbcTableHandle filterWithConstraintExpressionResult = new JdbcTableHandle(baseTableHandle.getRelationHandle(), TupleDomain.all(), (List)ImmutableList.of((Object)new ParameterizedExpression("like", (List)ImmutableList.of())), Optional.empty(), OptionalLong.empty(), Optional.empty(), Optional.of(ImmutableSet.of()), 0, Optional.empty(), (List)ImmutableList.of());
        Assertions.assertThat((Optional)this.metadata.applyTableScanRedirect((ConnectorSession)session, (ConnectorTableHandle)filterWithConstraintExpressionResult)).isEmpty();
    }

    @Test
    public void testColumnAliasTruncation() {
        OptionalInt maxLength = OptionalInt.of(30);
        Assertions.assertThat((String)DefaultJdbcMetadata.createSyntheticJoinProjectionColumn((JdbcColumnHandle)TestDefaultJdbcMetadata.column("no_truncation"), (int)123, (OptionalInt)maxLength).getColumnName()).isEqualTo("no_truncation_123");
        Assertions.assertThat((String)DefaultJdbcMetadata.createSyntheticJoinProjectionColumn((JdbcColumnHandle)TestDefaultJdbcMetadata.column("long_column_name_gets_truncated"), (int)123, (OptionalInt)maxLength).getColumnName()).isEqualTo("long_column_name_gets_trun_123");
        Assertions.assertThat((String)DefaultJdbcMetadata.createSyntheticJoinProjectionColumn((JdbcColumnHandle)TestDefaultJdbcMetadata.column("long_id_causes_truncation"), (int)Integer.MAX_VALUE, (OptionalInt)maxLength).getColumnName()).isEqualTo("long_id_causes_trun_2147483647");
        Assertions.assertThat((String)DefaultJdbcMetadata.createSyntheticJoinProjectionColumn((JdbcColumnHandle)TestDefaultJdbcMetadata.column("id_equals_max_length"), (int)1234, (OptionalInt)OptionalInt.of(4)).getColumnName()).isEqualTo("1234");
        Assertions.assertThat((String)DefaultJdbcMetadata.createSyntheticJoinProjectionColumn((JdbcColumnHandle)TestDefaultJdbcMetadata.column("id_and_separator_equals_max_length"), (int)1234, (OptionalInt)OptionalInt.of(5)).getColumnName()).isEqualTo("_1234");
    }

    @Test
    public void testSyntheticIdExceedsLength() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultJdbcMetadata.createSyntheticJoinProjectionColumn((JdbcColumnHandle)TestDefaultJdbcMetadata.column("id_exceeds_max_length"), (int)1234, (OptionalInt)OptionalInt.of(3))).isInstanceOf(VerifyException.class)).hasMessage("Maximum allowed column name length is 3 but next synthetic id has length 4");
    }

    @Test
    public void testNegativeSyntheticId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DefaultJdbcMetadata.createSyntheticJoinProjectionColumn((JdbcColumnHandle)TestDefaultJdbcMetadata.column("negative_id"), (int)Integer.MIN_VALUE, (OptionalInt)OptionalInt.of(30))).isInstanceOf(VerifyException.class)).hasMessage("nextSyntheticColumnId rolled over and is not monotonically increasing any more");
    }

    @Test
    public void testAggregationColumnAliasMaxLength() {
        Assertions.assertThat((int)DefaultJdbcMetadata.createSyntheticAggregationColumn((AggregateFunction)new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(), List.of(), false, Optional.empty()), (JdbcTypeHandle)TestingJdbcTypeHandle.JDBC_BIGINT, (int)Integer.MAX_VALUE).getColumnName().length()).isEqualTo(19);
    }

    private static JdbcColumnHandle column(String columnName) {
        return JdbcColumnHandle.builder().setJdbcTypeHandle(TestingJdbcTypeHandle.JDBC_VARCHAR).setColumnType((Type)VarcharType.VARCHAR).setColumnName(columnName).build();
    }

    private JdbcTableHandle applyCountAggregation(ConnectorSession session, ConnectorTableHandle tableHandle, List<List<ColumnHandle>> groupByColumns) {
        Optional aggResult = this.metadata.applyAggregation(session, tableHandle, (List)ImmutableList.of((Object)new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(), List.of(), false, Optional.empty())), (Map)ImmutableMap.of(), groupByColumns);
        Assertions.assertThat((Optional)aggResult).isPresent();
        return (JdbcTableHandle)((AggregationApplicationResult)aggResult.get()).getHandle();
    }

    private JdbcTableHandle applyFilter(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        Optional filterResult = this.metadata.applyFilter(session, tableHandle, constraint);
        Assertions.assertThat((Optional)filterResult).isPresent();
        return (JdbcTableHandle)((ConstraintApplicationResult)filterResult.get()).getHandle();
    }

    private /* synthetic */ Optional lambda$testAggregationPushdownForTableHandle$7(ConnectorSession session, ColumnHandle groupByColumn, ConnectorTableHandle handle) {
        return this.metadata.applyAggregation(session, handle, (List)ImmutableList.of((Object)new AggregateFunction("count", (Type)BigintType.BIGINT, List.of(), List.of(), false, Optional.empty())), (Map)ImmutableMap.of(), (List)ImmutableList.of((Object)ImmutableList.of((Object)groupByColumn)));
    }

    private /* synthetic */ void lambda$testNonTransactionalInsertValidation$3(ConnectorSession session) throws Throwable {
        this.metadata.beginInsert(session, (ConnectorTableHandle)this.tableHandle, (List)ImmutableList.of(), RetryMode.RETRIES_ENABLED);
    }

    private /* synthetic */ void lambda$testNonTransactionalInsertValidation$2(ConnectorSession session, ConnectorTableMetadata tableMetadata) throws Throwable {
        this.metadata.beginCreateTable(session, tableMetadata, Optional.empty(), RetryMode.RETRIES_ENABLED, false);
    }

    private static class GroupingSetsEnabledJdbcClient
    extends ForwardingJdbcClient {
        private final JdbcClient delegate;
        private final Optional<Boolean> supportsRetriesOverride;
        private final Optional<TableScanRedirectApplicationResult> tableScanRedirectApplicationResult;

        public GroupingSetsEnabledJdbcClient(JdbcClient jdbcClient, Optional<Boolean> supportsRetriesOverride) {
            this(jdbcClient, supportsRetriesOverride, Optional.empty());
        }

        public GroupingSetsEnabledJdbcClient(JdbcClient jdbcClient, Optional<Boolean> supportsRetriesOverride, Optional<TableScanRedirectApplicationResult> tableScanRedirectApplicationResult) {
            this.delegate = jdbcClient;
            this.supportsRetriesOverride = supportsRetriesOverride;
            this.tableScanRedirectApplicationResult = Objects.requireNonNull(tableScanRedirectApplicationResult, "tableScanRedirectApplicationResult is null");
        }

        protected JdbcClient delegate() {
            return this.delegate;
        }

        public boolean supportsRetries() {
            return this.supportsRetriesOverride.orElseGet(() -> super.supportsRetries());
        }

        public Optional<TableScanRedirectApplicationResult> getTableScanRedirection(ConnectorSession session, JdbcTableHandle tableHandle) {
            return this.tableScanRedirectApplicationResult;
        }

        public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
            return !"no_aggregation_pushdown".equalsIgnoreCase(table.getRequiredNamedRelation().getRemoteTableName().getTableName());
        }
    }
}

