/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.TestingDatabase;
import io.trino.plugin.jdbc.TestingJdbcTypeHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingSession;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestJdbcClient {
    private static final ConnectorSession session = TestingSession.testSessionBuilder().build().toConnectorSession();
    private TestingDatabase database;
    private String catalogName;
    private JdbcClient jdbcClient;

    @BeforeAll
    public void setUp() throws Exception {
        this.database = new TestingDatabase();
        this.catalogName = this.database.getConnection().getCatalog();
        this.jdbcClient = this.database.getJdbcClient();
    }

    @AfterAll
    public void tearDown() throws Exception {
        this.database.close();
        this.database = null;
    }

    @Test
    public void testMetadata() {
        Assertions.assertThat((Collection)this.jdbcClient.getSchemaNames(session)).contains((Object[])new String[]{"example", "tpch"});
        Assertions.assertThat((List)this.jdbcClient.getTableNames(session, Optional.of("example"))).containsExactly((Object[])new SchemaTableName[]{new SchemaTableName("example", "numbers"), new SchemaTableName("example", "timestamps"), new SchemaTableName("example", "view_source"), new SchemaTableName("example", "view")});
        Assertions.assertThat((List)this.jdbcClient.getTableNames(session, Optional.of("tpch"))).containsExactly((Object[])new SchemaTableName[]{new SchemaTableName("tpch", "lineitem"), new SchemaTableName("tpch", "orders")});
        SchemaTableName schemaTableName = new SchemaTableName("example", "numbers");
        Optional table = this.jdbcClient.getTableHandle(session, schemaTableName);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.isPresent()).withFailMessage("table is missing", new Object[0])).isTrue();
        Assertions.assertThat((String)((JdbcTableHandle)table.get()).getRequiredNamedRelation().getRemoteTableName().getCatalogName().orElse(null)).isEqualTo(this.catalogName.toUpperCase(Locale.ENGLISH));
        Assertions.assertThat((String)((JdbcTableHandle)table.get()).getRequiredNamedRelation().getRemoteTableName().getSchemaName().orElse(null)).isEqualTo("EXAMPLE");
        Assertions.assertThat((String)((JdbcTableHandle)table.get()).getRequiredNamedRelation().getRemoteTableName().getTableName()).isEqualTo("NUMBERS");
        Assertions.assertThat((Object)((JdbcTableHandle)table.get()).getRequiredNamedRelation().getSchemaTableName()).isEqualTo((Object)schemaTableName);
        Assertions.assertThat((List)this.jdbcClient.getColumns(session, (JdbcTableHandle)table.orElse(null))).containsExactly((Object[])new JdbcColumnHandle[]{new JdbcColumnHandle("TEXT", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), new JdbcColumnHandle("TEXT_SHORT", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.createVarcharType((int)32)), new JdbcColumnHandle("VALUE", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT)});
    }

    @Test
    public void testMetadataWithSchemaPattern() {
        SchemaTableName schemaTableName = new SchemaTableName("exa_ple", "num_ers");
        Optional table = this.jdbcClient.getTableHandle(session, schemaTableName);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.isPresent()).withFailMessage("table is missing", new Object[0])).isTrue();
        Assertions.assertThat((List)this.jdbcClient.getColumns(session, (JdbcTableHandle)table.get())).containsExactly((Object[])new JdbcColumnHandle[]{new JdbcColumnHandle("TE_T", TestingJdbcTypeHandle.JDBC_VARCHAR, (Type)VarcharType.VARCHAR), new JdbcColumnHandle("VA%UE", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT)});
    }

    @Test
    public void testMetadataWithFloatAndDoubleCol() {
        SchemaTableName schemaTableName = new SchemaTableName("exa_ple", "table_with_float_col");
        Optional table = this.jdbcClient.getTableHandle(session, schemaTableName);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.isPresent()).withFailMessage("table is missing", new Object[0])).isTrue();
        Assertions.assertThat((List)this.jdbcClient.getColumns(session, (JdbcTableHandle)table.get())).containsExactly((Object[])new JdbcColumnHandle[]{new JdbcColumnHandle("COL1", TestingJdbcTypeHandle.JDBC_BIGINT, (Type)BigintType.BIGINT), new JdbcColumnHandle("COL2", TestingJdbcTypeHandle.JDBC_DOUBLE, (Type)DoubleType.DOUBLE), new JdbcColumnHandle("COL3", TestingJdbcTypeHandle.JDBC_DOUBLE, (Type)DoubleType.DOUBLE), new JdbcColumnHandle("COL4", TestingJdbcTypeHandle.JDBC_REAL, (Type)RealType.REAL)});
    }

    @Test
    public void testMetadataWithTimestampCol() {
        SchemaTableName schemaTableName = new SchemaTableName("example", "timestamps");
        Optional table = this.jdbcClient.getTableHandle(session, schemaTableName);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)table.isPresent()).withFailMessage("table is missing", new Object[0])).isTrue();
        Assertions.assertThat((List)this.jdbcClient.getColumns(session, (JdbcTableHandle)table.get())).containsExactly((Object[])new JdbcColumnHandle[]{new JdbcColumnHandle("TS_3", TestingJdbcTypeHandle.JDBC_TIMESTAMP, (Type)TimestampType.TIMESTAMP_MILLIS), new JdbcColumnHandle("TS_6", TestingJdbcTypeHandle.JDBC_TIMESTAMP, (Type)TimestampType.TIMESTAMP_MICROS), new JdbcColumnHandle("TS_9", TestingJdbcTypeHandle.JDBC_TIMESTAMP, (Type)TimestampType.TIMESTAMP_NANOS)});
    }

    @Test
    public void testCreateSchema() {
        String schemaName = "test schema";
        this.jdbcClient.createSchema(session, schemaName);
        Assertions.assertThat((Collection)this.jdbcClient.getSchemaNames(session)).contains((Object[])new String[]{schemaName});
        this.jdbcClient.dropSchema(session, schemaName, false);
        Assertions.assertThat((Collection)this.jdbcClient.getSchemaNames(session)).doesNotContain((Object[])new String[]{schemaName});
    }

    @Test
    public void testRenameTable() {
        String schemaName = "test_schema";
        SchemaTableName oldTable = new SchemaTableName(schemaName, "foo");
        SchemaTableName newTable = new SchemaTableName(schemaName, "bar");
        ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(oldTable, (List)ImmutableList.of((Object)new ColumnMetadata("text", (Type)VarcharType.VARCHAR)));
        this.jdbcClient.createSchema(session, schemaName);
        this.jdbcClient.createTable(session, tableMetadata);
        this.jdbcClient.renameTable(session, (JdbcTableHandle)this.jdbcClient.getTableHandle(session, oldTable).get(), newTable);
        this.jdbcClient.dropTable(session, (JdbcTableHandle)this.jdbcClient.getTableHandle(session, newTable).get());
        this.jdbcClient.dropSchema(session, schemaName, false);
        ((ListAssert)Assertions.assertThat((List)this.jdbcClient.getTableNames(session, Optional.empty())).doesNotContain((Object[])new SchemaTableName[]{oldTable})).doesNotContain((Object[])new SchemaTableName[]{newTable});
        Assertions.assertThat((Collection)this.jdbcClient.getSchemaNames(session)).doesNotContain((Object[])new String[]{schemaName});
    }
}

