/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BaseJdbcConnectionCreationTest;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.H2QueryRunner;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.TestingH2JdbcClient;
import io.trino.plugin.jdbc.TestingH2JdbcModule;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.credential.EmptyCredentialProvider;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.h2.Driver;
import org.junit.jupiter.api.Test;

public class TestJdbcConnectionAccesses
extends BaseJdbcConnectionCreationTest {
    protected QueryRunner createQueryRunner() throws Exception {
        String connectionUrl = TestingH2JdbcModule.createH2ConnectionUrl();
        DriverConnectionFactory delegate = DriverConnectionFactory.builder((java.sql.Driver)new Driver(), (String)connectionUrl, (CredentialProvider)new EmptyCredentialProvider()).build();
        this.connectionFactory = new BaseJdbcConnectionCreationTest.ConnectionCountingConnectionFactory(delegate);
        return H2QueryRunner.createH2QueryRunner(ImmutableList.of((Object)TpchTable.NATION, (Object)TpchTable.REGION), (Map<String, String>)ImmutableMap.of((Object)"connection-url", (Object)connectionUrl, (Object)"query.reuse-connection", (Object)"false"), (Map<String, String>)ImmutableMap.of((Object)"node-scheduler.include-coordinator", (Object)"false"), new TestingConnectionH2Module(this.connectionFactory));
    }

    @Test
    public void testJdbcConnectionCreations() {
        this.assertJdbcConnections("SELECT * FROM nation LIMIT 1", 3, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM nation ORDER BY nationkey LIMIT 1", 3, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM nation WHERE nationkey = 1", 3, Optional.empty());
        this.assertJdbcConnections("SELECT avg(nationkey) FROM nation", 3, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM nation, region", 6, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM nation n, region r WHERE n.regionkey = r.regionkey", 6, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM nation JOIN region USING(regionkey)", 6, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM information_schema.schemata", 1, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM information_schema.tables", 1, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM information_schema.columns", 5, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM nation", 3, Optional.empty());
        this.assertJdbcConnections("CREATE TABLE copy_of_nation AS SELECT * FROM nation", 11, Optional.empty());
        this.assertJdbcConnections("INSERT INTO copy_of_nation SELECT * FROM nation", 12, Optional.empty());
        this.assertJdbcConnections("DELETE FROM copy_of_nation WHERE nationkey = 3", 3, Optional.empty());
        this.assertJdbcConnections("UPDATE copy_of_nation SET name = 'POLAND' WHERE nationkey = 1", 3, Optional.empty());
        this.assertJdbcConnections("MERGE INTO copy_of_nation n USING region r ON r.regionkey= n.regionkey WHEN MATCHED THEN DELETE", 4, Optional.of("This connector does not support modifying table rows"));
        this.assertJdbcConnections("DROP TABLE copy_of_nation", 2, Optional.empty());
        this.assertJdbcConnections("SHOW SCHEMAS", 1, Optional.empty());
        this.assertJdbcConnections("SHOW TABLES", 2, Optional.empty());
        this.assertJdbcConnections("SHOW STATS FOR nation", 2, Optional.empty());
        this.assertJdbcConnections("SELECT * FROM system.jdbc.columns WHERE table_cat = 'jdbc'", 5, Optional.empty());
    }

    private static class TestingConnectionH2Module
    implements Module {
        private final BaseJdbcConnectionCreationTest.ConnectionCountingConnectionFactory connectionCountingConnectionFactory;

        TestingConnectionH2Module(BaseJdbcConnectionCreationTest.ConnectionCountingConnectionFactory connectionCountingConnectionFactory) {
            this.connectionCountingConnectionFactory = Objects.requireNonNull(connectionCountingConnectionFactory, "connectionCountingConnectionFactory is null");
        }

        public void configure(Binder binder) {
        }

        @Provides
        @Singleton
        @ForBaseJdbc
        public static JdbcClient provideJdbcClient(BaseJdbcConfig config, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, IdentifierMapping identifierMapping) {
            return new TestingH2JdbcClient(config, connectionFactory, queryBuilder, identifierMapping);
        }

        @Provides
        @Singleton
        @ForBaseJdbc
        public ConnectionFactory getConnectionFactory() {
            return this.connectionCountingConnectionFactory;
        }
    }
}

