/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.plugin.jdbc.JdbcJoinPushdownConfig;
import io.trino.plugin.jdbc.JoinPushdownStrategy;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestJdbcJoinPushdownConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((JdbcJoinPushdownConfig)ConfigAssertions.recordDefaults(JdbcJoinPushdownConfig.class)).setJoinPushdownStrategy(JoinPushdownStrategy.AUTOMATIC).setJoinPushdownAutomaticMaxTableSize(null).setJoinPushdownAutomaticMaxJoinToTablesRatio(1.25));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"join-pushdown.strategy", (Object)"EAGER").put((Object)"experimental.join-pushdown.automatic.max-table-size", (Object)"10MB").put((Object)"experimental.join-pushdown.automatic.max-join-to-tables-ratio", (Object)"2.0").buildOrThrow();
        JdbcJoinPushdownConfig expected = new JdbcJoinPushdownConfig().setJoinPushdownStrategy(JoinPushdownStrategy.EAGER).setJoinPushdownAutomaticMaxTableSize(DataSize.valueOf((String)"10MB")).setJoinPushdownAutomaticMaxJoinToTablesRatio(2.0);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

