/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.jdbc.JdbcMetadataConfig;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestJdbcMetadataConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((JdbcMetadataConfig)ConfigAssertions.recordDefaults(JdbcMetadataConfig.class)).setComplexExpressionPushdownEnabled(true).setJoinPushdownEnabled(false).setComplexJoinPushdownEnabled(true).setAggregationPushdownEnabled(true).setTopNPushdownEnabled(true).setBulkListColumns(false).setDomainCompactionThreshold(256));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"complex-expression-pushdown.enabled", (Object)"false").put((Object)"join-pushdown.enabled", (Object)"true").put((Object)"join-pushdown.with-expressions", (Object)"false").put((Object)"aggregation-pushdown.enabled", (Object)"false").put((Object)"jdbc.bulk-list-columns.enabled", (Object)"true").put((Object)"domain-compaction-threshold", (Object)"42").put((Object)"topn-pushdown.enabled", (Object)"false").buildOrThrow();
        JdbcMetadataConfig expected = new JdbcMetadataConfig().setComplexExpressionPushdownEnabled(false).setJoinPushdownEnabled(true).setComplexJoinPushdownEnabled(false).setAggregationPushdownEnabled(false).setTopNPushdownEnabled(false).setBulkListColumns(true).setDomainCompactionThreshold(42);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

