/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.jdbc.H2QueryRunner;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.TestingH2JdbcClient;
import io.trino.plugin.jdbc.TestingH2JdbcModule;
import io.trino.spi.connector.ConnectorSession;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestJdbcTableProperties
extends AbstractTestQueryFramework {
    private final Map<String, String> properties = TestingH2JdbcModule.createProperties();
    private Runnable onGetTableProperties = () -> {};

    protected QueryRunner createQueryRunner() throws Exception {
        TestingH2JdbcModule module = new TestingH2JdbcModule((config, connectionFactory, queryBuilder, identifierMapping) -> new TestingH2JdbcClient(config, connectionFactory, queryBuilder, identifierMapping){

            public Map<String, Object> getTableProperties(ConnectorSession session, JdbcTableHandle tableHandle) {
                TestJdbcTableProperties.this.onGetTableProperties.run();
                return ImmutableMap.of();
            }
        });
        return H2QueryRunner.createH2QueryRunner(List.of(TpchTable.NATION), this.properties, module);
    }

    @Test
    public void testGetTablePropertiesIsNotCalledForSelect() {
        this.onGetTableProperties = () -> Assertions.fail((String)"Unexpected call of: getTableProperties");
        this.assertUpdate("CREATE TABLE copy_of_nation AS SELECT * FROM nation", 25L);
        this.assertQuerySucceeds("SELECT * FROM copy_of_nation");
        this.assertQuerySucceeds("SELECT nationkey FROM copy_of_nation");
    }

    @Test
    public void testGetTablePropertiesIsCalled() {
        AtomicInteger counter = new AtomicInteger();
        this.onGetTableProperties = counter::incrementAndGet;
        this.assertQuerySucceeds("SHOW CREATE TABLE nation");
        Assertions.assertThat((int)counter.get()).isOne();
    }
}

