/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.LazyConnectionFactory;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.credential.EmptyCredentialProvider;
import io.trino.testing.TestingConnectorSession;
import java.sql.Connection;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.Assertions;
import org.h2.Driver;
import org.junit.jupiter.api.Test;

public class TestLazyConnectionFactory {
    @Test
    public void testNoConnectionIsCreated() throws Exception {
        ConnectionFactory failingConnectionFactory = connectorSession -> {
            throw new AssertionError((Object)"Expected no connection creation");
        };
        try (LazyConnectionFactory lazyConnectionFactory = new LazyConnectionFactory(failingConnectionFactory);){
            Connection ignored = lazyConnectionFactory.openConnection(TestingConnectorSession.SESSION);
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    @Test
    public void testConnectionCannotBeReusedAfterClose() throws Exception {
        String url = String.format("jdbc:h2:mem:test%s;DB_CLOSE_DELAY=-1", System.nanoTime() + ThreadLocalRandom.current().nextLong());
        try (DriverConnectionFactory driverConnectionFactory = DriverConnectionFactory.builder((java.sql.Driver)new Driver(), (String)url, (CredentialProvider)new EmptyCredentialProvider()).build();
             LazyConnectionFactory lazyConnectionFactory = new LazyConnectionFactory((ConnectionFactory)driverConnectionFactory);){
            Connection connection = lazyConnectionFactory.openConnection(TestingConnectorSession.SESSION);
            connection.close();
            Assertions.assertThatThrownBy(connection::createStatement).hasMessage("Connection is already closed");
        }
    }
}

