/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.jdbc.QueryParameter;
import io.trino.plugin.jdbc.expression.BaseTestRewriteLikeWithCaseSensitivity;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.plugin.jdbc.expression.RewriteLikeEscapeWithCaseSensitivity;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRewriteLikeEscapeWithCaseSensitivity
extends BaseTestRewriteLikeWithCaseSensitivity {
    private final RewriteLikeEscapeWithCaseSensitivity rewrite = new RewriteLikeEscapeWithCaseSensitivity();

    @Override
    protected ConnectorExpressionRule<Call, ParameterizedExpression> getRewrite() {
        return this.rewrite;
    }

    @Test
    public void testRewriteLikeEscapeCallInvalidNumberOfArguments() {
        Call expression = new Call((Type)BooleanType.BOOLEAN, new FunctionName("$like"), List.of(new Variable("case_sensitive_value", (Type)VarcharType.VARCHAR)));
        this.assertNoRewrite(expression);
    }

    @Test
    public void testRewriteLikeEscapeCallInvalidTypeValue() {
        Call expression = new Call((Type)BooleanType.BOOLEAN, new FunctionName("$like"), List.of(new Variable("case_sensitive_value", (Type)BigintType.BIGINT), new Variable("pattern", (Type)VarcharType.VARCHAR), new Variable("escape", (Type)VarcharType.VARCHAR)));
        this.assertNoRewrite(expression);
    }

    @Test
    public void testRewriteLikeEscapeCallInvalidTypePattern() {
        Call expression = new Call((Type)BooleanType.BOOLEAN, new FunctionName("$like"), List.of(new Variable("case_sensitive_value", (Type)VarcharType.VARCHAR), new Variable("pattern", (Type)BigintType.BIGINT), new Variable("escape", (Type)VarcharType.VARCHAR)));
        this.assertNoRewrite(expression);
    }

    @Test
    public void testRewriteLikeEscapeCallInvalidTypeEscape() {
        Call expression = new Call((Type)BooleanType.BOOLEAN, new FunctionName("$like"), List.of(new Variable("case_sensitive_value", (Type)VarcharType.VARCHAR), new Variable("pattern", (Type)VarcharType.VARCHAR), new Variable("escape", (Type)BigintType.BIGINT)));
        this.assertNoRewrite(expression);
    }

    @Test
    public void testRewriteLikeEscapeCallOnCaseInsensitiveValue() {
        Call expression = new Call((Type)BooleanType.BOOLEAN, new FunctionName("$like"), List.of(new Variable("case_insensitive_value", (Type)VarcharType.VARCHAR), new Variable("pattern", (Type)VarcharType.VARCHAR), new Variable("escape", (Type)VarcharType.VARCHAR)));
        this.assertNoRewrite(expression);
    }

    @Test
    public void testRewriteLikeEscapeCallOnCaseSensitiveValue() {
        Call expression = new Call((Type)BooleanType.BOOLEAN, new FunctionName("$like"), List.of(new Variable("case_sensitive_value", (Type)VarcharType.VARCHAR), new Variable("pattern", (Type)VarcharType.VARCHAR), new Variable("escape", (Type)VarcharType.VARCHAR)));
        ParameterizedExpression rewritten = this.apply(expression).orElseThrow();
        Assertions.assertThat((String)rewritten.expression()).isEqualTo("\"case_sensitive_value\" LIKE \"pattern\" ESCAPE \"escape\"");
        Assertions.assertThat((List)rewritten.parameters()).isEqualTo(List.of(new QueryParameter((Type)VarcharType.VARCHAR, Optional.of("case_sensitive_value")), new QueryParameter((Type)VarcharType.VARCHAR, Optional.of("pattern")), new QueryParameter((Type)VarcharType.VARCHAR, Optional.of("escape"))));
    }
}

